/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.hibernate;

import java.util.List;

import org.hibernate.Query;
import org.jbpm.pvm.Execution;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.jobexecutor.JobDbSession;
import org.jbpm.pvm.internal.util.Clock;

/**
 * @author Tom Baeyens
 */
public class HibernateJobDbSession extends HibernateDbSession implements JobDbSession {
  
  public JobImpl<?> findFirstAcquirableJob() {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.job.hbm.xml
    Query query = session.getNamedQuery("findFirstAcquirableJob");
    query.setTimestamp("now", Clock.getCurrentTime());
    query.setMaxResults(1);
    return (JobImpl<?>) query.uniqueResult();
  }

  public List<JobImpl<?>> findExclusiveJobs(Execution processInstance) {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.job.hbm.xml
    Query query = session.getNamedQuery("findExclusiveJobs");
    query.setTimestamp("now", Clock.getCurrentTime());
    query.setEntity("processInstance", processInstance);
    return query.list();
  }

  public JobImpl<?> findFirstDueJob() {
    // query definition can be found at the bottom of resource org/jbpm/pvm/hibernate.job.hbm.xml
    Query query = session.getNamedQuery("findFirstDueJob");
    query.setMaxResults(1);
    return (JobImpl<?>) query.uniqueResult();
  }

  public JobImpl<?> getJob(long jobId) {
    return JobImpl.class.cast(session.get(JobImpl.class, jobId));
  }
}
