package org.jbpm.pvm.internal.lob;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BlobStrategyChopped implements BlobStrategy {

  int chopSize = 1024;

  public void set(byte[] bytes, Blob blob) {
    blob.setChops(chop(bytes));
  }

  public byte[] get(Blob blob) {
    return glue(blob.getChops());
  }

  public List<byte[]> chop(byte[] bytes) {
    List<byte[]> chops = null;
    if ( (bytes!=null)
         && (bytes.length>0) ){
      chops = new ArrayList<byte[]>();
      int index = 0;
      while ( (bytes.length-index) > chopSize ) {
        byte[] byteBlock = new byte[chopSize];
        System.arraycopy(bytes, index, byteBlock, 0, chopSize);
        chops.add(byteBlock);
        index+=chopSize;
      }
      byte[] byteBlock = new byte[bytes.length-index];
      System.arraycopy(bytes, index, byteBlock, 0, bytes.length-index);
      chops.add(byteBlock);
    }
    return chops;
  }

  public byte[] glue(List<byte[]> chops) {
    byte[] bytes = null;
    if (chops!=null) {
      Iterator iter = chops.iterator();
      while (iter.hasNext()) {
        byte[] byteBlock = (byte[]) iter.next();
        if (bytes==null) {
          bytes = byteBlock;
        } else {
          byte[] oldValue = bytes;
          bytes = new byte[bytes.length+byteBlock.length];
          System.arraycopy(oldValue, 0, bytes, 0, oldValue.length);
          System.arraycopy(byteBlock, 0, bytes, oldValue.length, byteBlock.length);
        }
      }
    }
    return bytes;
  }
}
