/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.test.base;

import org.jbpm.pvm.ExecutionService;
import org.jbpm.pvm.ManagementService;
import org.jbpm.pvm.ProcessService;
import org.jbpm.pvm.internal.cmd.CommandService;


/** for tests that use persistence through a command service.
 * 
 * The DB is cleaned inbetween tests.  No environment is created.
 * 
 * @author Tom Baeyens
 */
public abstract class DbTestCase extends EnvironmentFactoryTestCase {
  
  protected CommandService commandService;
  protected ProcessService processService;
  protected ExecutionService executionService;
  protected ManagementService managementService;

  public DbTestCase() {
    super();
  }
  
  public DbTestCase(String configResource) {
    super(configResource);
  }
  
  public void setUp() throws Exception {
    super.setUp();

    if (isEnvironmentFactoryCached()) {
      Db.clean(getEnvironmentFactory());
    }

    commandService = getEnvironmentFactory().get(CommandService.class);
    processService = getEnvironmentFactory().get(ProcessService.class);
    executionService = getEnvironmentFactory().get(ExecutionService.class);
    managementService = getEnvironmentFactory().get(ManagementService.class);
  }
  
  public void tearDown() throws Exception {
    commandService = null;
    processService = null;
    executionService = null;
    managementService = null;
    super.tearDown();
  }
}
