/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.test.base;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.env.EnvironmentFactory;
import org.jbpm.pvm.env.PvmEnvironmentFactory;
import org.jbpm.pvm.internal.log.Jdk14LogFactory;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.log.LogFormatter;

public abstract class JbpmTestCase extends TestCase {

  static {
    Jdk14LogFactory.initializeJdk14Logging(); 
  }

  public void setUp() throws Exception {
    LogFormatter.resetIndentation();
    log.info("=== starting "+getName()+" =============================");
  }

  public void tearDown() throws Exception {
    log.info("=== ending "+getName()+" =============================\n");
  }

  public void assertTextPresent(String expected, String value) {
    if ( (value==null)
         || (value.indexOf(expected)==-1)
       ) {
      throw new AssertionFailedError("expected presence of '"+expected+"' but was '"+value+"'");
    }
  }
  
  public static Environment openEnvironment(String xmlString) {
    EnvironmentFactory environmentFactory = PvmEnvironmentFactory.parseXmlString(xmlString);
    return environmentFactory.openEnvironment();
  }

  protected void runTest() throws Throwable {
    try {
      super.runTest();
    } catch (AssertionFailedError e) {
      log.error("");
      log.error("ASSERTION FAILURE: "+e.getMessage());
      log.error("");
      throw e;
    } catch (Throwable t) {
      t.printStackTrace();
      throw t;
    }
  }

  static protected Log log = Log.getLog(JbpmTestCase.class.getName());
}
