/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.pvm.client.ClientExecution;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.internal.cmd.CommandException;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.session.DbSession;
import org.jbpm.pvm.session.PvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommand<T>
implements Command<T> {
    protected ClientExecution getExecution(Environment environment, long executionDbid) {
        DbSession dbSession = environment.get(DbSession.class);
        ClientExecution execution = dbSession.get(ExecutionImpl.class, executionDbid);
        if (execution == null) {
            throw new CommandException("execution " + executionDbid + " doesn't exist");
        }
        return execution;
    }

    protected ClientExecution getExecution(Environment environment, String executionId) {
        PvmDbSession dbSession = environment.get(PvmDbSession.class);
        ClientExecution execution = dbSession.findExecutionById(executionId);
        if (execution == null) {
            throw new CommandException("execution " + executionId + " doesn't exist");
        }
        return execution;
    }
}

