/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.cmd.Command;
import org.jbpm.pvm.model.OpenProcessDefinition;
import org.jbpm.pvm.session.PvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindProcessDefinitionCmd
implements Command<OpenProcessDefinition> {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionName;
    protected int processDefinitionVersion;

    public FindProcessDefinitionCmd(String processDefinitionName, int processDefinitionVersion) {
        if (processDefinitionName == null) {
            throw new PvmException("processDefinitionName is null");
        }
        this.processDefinitionName = processDefinitionName;
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public OpenProcessDefinition execute(Environment environment) throws Exception {
        PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);
        return pvmDbSession.findProcessDefinitionByName(this.processDefinitionName, this.processDefinitionVersion);
    }
}

