/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.deploy;

import org.jbpm.pvm.Deployment;
import org.jbpm.pvm.ProcessDefinition;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.deploy.Deployer;
import org.jbpm.pvm.internal.log.Log;

public class CreateProcess
implements Deployer {
    private static final Log log = Log.getLog(CreateProcess.class.getName());
    protected Class<?> processDefinitionClass;

    public void deploy(Deployment deployment) {
        ProcessDefinition processDefinition = deployment.getProcessDefinition();
        if (processDefinition == null) {
            if (this.processDefinitionClass == null) {
                throw new PvmException("create-process deployer improperly configured: no class specified");
            }
            try {
                log.trace("creating new " + this.processDefinitionClass.getName());
                processDefinition = (ProcessDefinition)this.processDefinitionClass.newInstance();
            }
            catch (Exception e) {
                throw new PvmException("couldn't instantiate process definition with class " + this.processDefinitionClass);
            }
            deployment.setProcessDefinition(processDefinition);
        } else {
            log.trace("using process definition provided in deployment");
        }
    }
}

