/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.hibernate;

import java.util.List;
import org.hibernate.Query;
import org.jbpm.pvm.Execution;
import org.jbpm.pvm.client.ClientExecution;
import org.jbpm.pvm.client.ClientProcessDefinition;
import org.jbpm.pvm.internal.hibernate.HibernateDbSession;
import org.jbpm.pvm.job.Job;
import org.jbpm.pvm.job.Message;
import org.jbpm.pvm.job.Timer;
import org.jbpm.pvm.session.PvmDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePvmDbSession
extends HibernateDbSession
implements PvmDbSession {
    @Override
    public List<String> findProcessDefinitionNames() {
        return this.session.getNamedQuery("findProcessDefinitionNames").list();
    }

    @Override
    public List<ClientProcessDefinition> findProcessDefinitionsByName(String name) {
        Query query = this.session.getNamedQuery("findProcessDefinitionsByName");
        query.setString("name", name);
        return query.list();
    }

    @Override
    public ClientProcessDefinition findProcessDefinitionByName(String name, int version) {
        Query query = this.session.getNamedQuery("findProcessDefinitionByNameAndVersion");
        query.setString("name", name);
        query.setInteger("version", version);
        ClientProcessDefinition processDefinition = (ClientProcessDefinition)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public ClientProcessDefinition findLatestProcessDefinitionByName(String name) {
        Query query = this.session.getNamedQuery("findProcessDefinitionsByName");
        query.setString("name", name);
        query.setMaxResults(1);
        ClientProcessDefinition processDefinition = (ClientProcessDefinition)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public ClientProcessDefinition findProcessDefinitionById(String processDefinitionId) {
        Query query = this.session.getNamedQuery("findProcessDefinitionsById");
        query.setString("id", processDefinitionId);
        query.setMaxResults(1);
        ClientProcessDefinition processDefinition = (ClientProcessDefinition)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public ClientExecution findExecutionById(String executionId) {
        Query query = this.session.getNamedQuery("findExecutionById");
        query.setString("id", executionId);
        query.setMaxResults(1);
        return (ClientExecution)query.uniqueResult();
    }

    @Override
    public Execution findExecutionByKey(String processDefinitionName, String executionKey) {
        Query query = this.session.getNamedQuery("findExecutionByKey");
        query.setString("processDefinitionName", processDefinitionName);
        query.setString("executionKey", executionKey);
        query.setMaxResults(1);
        return (ClientExecution)query.uniqueResult();
    }

    @Override
    public List<Timer> findTimers(int firstResult, int maxResults) {
        Query query = this.session.getNamedQuery("findTimers");
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public List<Message> findMessages(int firstResult, int maxResults) {
        Query query = this.session.getNamedQuery("findMessages");
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.list();
    }

    @Override
    public List<Job> findJobsWithException(int firstResult, int maxResults) {
        Query query = this.session.getNamedQuery("findJobsWithException");
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.list();
    }
}

