/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.env.Transaction;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.jobexecutor.JobAddedNotification;
import org.jbpm.pvm.internal.jobexecutor.JobExecutor;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.session.DbSession;
import org.jbpm.pvm.session.MessageSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorMessageSession
implements MessageSession {
    private static final Log log = Log.getLog(JobExecutorMessageSession.class.getName());
    DbSession dbSession;
    Transaction transaction;
    boolean isNotificationAdded;

    @Override
    public void send(MessageImpl<?> message) {
        log.debug("sending message " + ReflectUtil.getUnqualifiedClassName(message.getClass()));
        this.dbSession.save(message);
        if (!this.isNotificationAdded) {
            this.isNotificationAdded = true;
            log.trace("registering job executor notifier with " + this.transaction);
            JobExecutor jobExecutor = Environment.getCurrent().get(JobExecutor.class);
            if (jobExecutor == null) {
                throw new PvmException("no job executor configured to execute " + message);
            }
            this.transaction.registerSynchronization(new JobAddedNotification(jobExecutor));
        }
    }
}

