/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.lob;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.lob.Blob;
import org.jbpm.pvm.internal.lob.BlobStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobStrategyChopped
implements BlobStrategy {
    int chopSize = 1024;

    @Override
    public void set(byte[] bytes, Blob blob) {
        blob.setChops(this.chop(bytes));
    }

    @Override
    public byte[] get(Blob blob) {
        return this.glue(blob.getChops());
    }

    public List<byte[]> chop(byte[] bytes) {
        ArrayList<byte[]> chops = null;
        if (bytes != null && bytes.length > 0) {
            byte[] byteBlock;
            chops = new ArrayList<byte[]>();
            int index = 0;
            while (bytes.length - index > this.chopSize) {
                byteBlock = new byte[this.chopSize];
                System.arraycopy(bytes, index, byteBlock, 0, this.chopSize);
                chops.add(byteBlock);
                index += this.chopSize;
            }
            byteBlock = new byte[bytes.length - index];
            System.arraycopy(bytes, index, byteBlock, 0, bytes.length - index);
            chops.add(byteBlock);
        }
        return chops;
    }

    public byte[] glue(List<byte[]> chops) {
        byte[] bytes = null;
        if (chops != null) {
            for (byte[] byteBlock : chops) {
                if (bytes == null) {
                    bytes = byteBlock;
                    continue;
                }
                byte[] oldValue = bytes;
                bytes = new byte[bytes.length + byteBlock.length];
                System.arraycopy(oldValue, 0, bytes, 0, oldValue.length);
                System.arraycopy(byteBlock, 0, bytes, oldValue.length, byteBlock.length);
            }
        }
        return bytes;
    }
}

