/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.log;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.MemoryHandler;
import org.jbpm.pvm.internal.log.LogFormatter;

public class ErrorTriggeredFileHandler
extends Handler {
    private static final int DEFAULT_SIZE = 500;
    private static final Level DEFAULT_PUSH_LEVEL = Level.SEVERE;
    private static final String DEFAULT_PATTERN = "%h/jbpm%u.log";
    DecoratedMemoryHandler memoryHandler = null;
    FileHandler fileHandler = ErrorTriggeredFileHandler.getConfiguredTarget();

    public ErrorTriggeredFileHandler() throws SecurityException, IOException {
        this.memoryHandler = new DecoratedMemoryHandler(this.fileHandler, ErrorTriggeredFileHandler.getConfiguredSize(), ErrorTriggeredFileHandler.getConfiguredPushLevel());
    }

    private static Level getConfiguredPushLevel() {
        LogManager manager = LogManager.getLogManager();
        String pushLevelText = manager.getProperty(ErrorTriggeredFileHandler.class.getName() + ".push");
        if (pushLevelText == null) {
            return DEFAULT_PUSH_LEVEL;
        }
        try {
            return Level.parse(pushLevelText.trim());
        }
        catch (Exception ex) {
            return DEFAULT_PUSH_LEVEL;
        }
    }

    protected static int getConfiguredSize() {
        LogManager manager = LogManager.getLogManager();
        String sizeText = manager.getProperty(ErrorTriggeredFileHandler.class.getName() + ".size");
        if (sizeText == null) {
            return 500;
        }
        try {
            return Integer.parseInt(sizeText.trim());
        }
        catch (Exception ex) {
            return 500;
        }
    }

    protected static FileHandler getConfiguredTarget() throws SecurityException, IOException {
        LogManager manager = LogManager.getLogManager();
        String pattern = manager.getProperty(ErrorTriggeredFileHandler.class.getName() + ".pattern");
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        return new FileHandler(pattern);
    }

    public void close() throws SecurityException {
        this.memoryHandler.close();
    }

    public void flush() {
        this.memoryHandler.flush();
    }

    public void publish(LogRecord record) {
        this.memoryHandler.publish(record);
    }

    public class DecoratedMemoryHandler
    extends MemoryHandler {
        public DecoratedMemoryHandler(FileHandler target, int size, Level pushLevel) {
            super(target, size, pushLevel);
        }

        public void push() {
            ErrorTriggeredFileHandler.this.fileHandler.setFormatter(new LogFormatter());
            super.push();
            LogRecord emptyLine = new LogRecord(Level.INFO, "");
            emptyLine.setLoggerName("");
            ErrorTriggeredFileHandler.this.fileHandler.publish(emptyLine);
            LogRecord line = new LogRecord(Level.INFO, "---- END OF TRIGGERED PUSH ---------------------------------------------------");
            line.setLoggerName("");
            ErrorTriggeredFileHandler.this.fileHandler.publish(line);
            ErrorTriggeredFileHandler.this.fileHandler.publish(emptyLine);
            ErrorTriggeredFileHandler.this.fileHandler.publish(emptyLine);
        }
    }
}

