/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.TimerDefinitionImpl;
import org.jbpm.pvm.internal.model.VariableDefinitionImpl;
import org.jbpm.pvm.model.CompositeElement;
import org.jbpm.pvm.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeElementImpl
extends ObservableElementImpl
implements CompositeElement {
    private static final long serialVersionUID = 1L;
    protected List<NodeImpl> nodes;
    protected boolean hasVariableDefinitions;
    protected List<VariableDefinitionImpl> variableDefinitions;
    protected boolean hasTimerDefinitions;
    protected Set<TimerDefinitionImpl> timerDefinitions;
    protected transient Map<String, NodeImpl> nodesMap;

    public Node createNode() {
        return this.createNode(null);
    }

    public NodeImpl createNode(String nodeName) {
        NodeImpl node = new NodeImpl();
        node.setName(nodeName);
        this.addNode(node);
        return node;
    }

    public Node addNode(NodeImpl node) {
        node.setProcessDefinition(this.processDefinition);
        if (this.nodes == null) {
            this.nodes = new ArrayList<NodeImpl>();
        }
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
        }
        this.nodesMap = null;
        return node;
    }

    public boolean removeNode(NodeImpl node) {
        if (node != null && this.nodes != null) {
            boolean isRemoved = this.nodes.remove(node);
            if (isRemoved) {
                node.setParentNode(null);
                if (this.nodes.isEmpty()) {
                    this.nodes = null;
                }
                this.nodesMap = null;
            }
            return isRemoved;
        }
        return false;
    }

    @Override
    public NodeImpl getNode(String nodeName) {
        return this.getNodesMap() != null ? this.nodesMap.get(nodeName) : null;
    }

    @Override
    public boolean hasNode(String nodeName) {
        return this.getNodesMap() != null && this.nodesMap.containsKey(nodeName);
    }

    @Override
    public Node findNode(String nodeName) {
        if (this.nodes != null) {
            for (NodeImpl n : this.nodes) {
                Node node = n.findNode(nodeName);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    @Override
    public List<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public Map<String, Node> getNodesMap() {
        if (this.nodesMap == null) {
            this.nodesMap = NodeImpl.getNodesMap(this.nodes);
        }
        return this.nodesMap;
    }

    @Override
    public boolean hasNodes() {
        return this.nodes != null && !this.nodes.isEmpty();
    }

    public List<VariableDefinitionImpl> getVariableDefinitions() {
        if (!this.hasVariableDefinitions) {
            return Collections.EMPTY_LIST;
        }
        return this.variableDefinitions;
    }

    public VariableDefinitionImpl createVariableDefinition() {
        VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl();
        if (this.variableDefinitions == null) {
            this.variableDefinitions = new ArrayList<VariableDefinitionImpl>();
        }
        this.variableDefinitions.add(variableDefinition);
        this.hasVariableDefinitions = true;
        return variableDefinition;
    }

    public Set<TimerDefinitionImpl> getTimerDefinitions() {
        if (!this.hasTimerDefinitions) {
            return Collections.EMPTY_SET;
        }
        return this.timerDefinitions;
    }

    public TimerDefinitionImpl createTimerDefinition() {
        TimerDefinitionImpl timerDefinition = new TimerDefinitionImpl();
        if (this.timerDefinitions == null) {
            this.timerDefinitions = new HashSet<TimerDefinitionImpl>();
        }
        this.timerDefinitions.add(timerDefinition);
        this.hasTimerDefinitions = true;
        return timerDefinition;
    }
}

