/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.activity.Activity;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.ObjectReference;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.model.Node;
import org.jbpm.pvm.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
extends CompositeElementImpl
implements Node {
    private static final long serialVersionUID = 1L;
    protected ObjectReference<Activity> behaviourReference;
    protected List<TransitionImpl> outgoingTransitions;
    protected List<TransitionImpl> incomingTransitions;
    protected TransitionImpl defaultTransition;
    protected NodeImpl parentNode;
    protected boolean isLocalScope;
    protected boolean isExecutionAsync;
    protected boolean isSignalAsync;
    protected boolean isLeaveAsync;
    protected boolean isPreviousNeeded;
    protected transient Map<String, TransitionImpl> outgoingTransitionsMap;

    @Override
    public NodeImpl addNode(NodeImpl node) {
        node.setParentNode(this);
        super.addNode(node);
        return node;
    }

    @Override
    public Node findNode(String nodeName) {
        if (nodeName == null ? this.name == null : nodeName.equals(this.name)) {
            return this;
        }
        return super.findNode(nodeName);
    }

    public Transition createOutgoingTransition(NodeImpl destination) {
        return this.createOutgoingTransition(destination, null);
    }

    public TransitionImpl createOutgoingTransition(NodeImpl destination, String transitionName) {
        TransitionImpl transition = this.createOutgoingTransition(transitionName);
        if (destination != null) {
            destination.addIncomingTransition(transition);
        }
        return transition;
    }

    public TransitionImpl createOutgoingTransition(String transitionName) {
        TransitionImpl transition = new TransitionImpl();
        transition.setName(transitionName);
        this.addOutgoingTransition(transition);
        if (this.defaultTransition == null) {
            this.defaultTransition = transition;
        }
        return transition;
    }

    public Transition addOutgoingTransition(TransitionImpl transition) {
        transition.setSource(this);
        if (this.outgoingTransitions == null) {
            this.outgoingTransitions = new ArrayList<TransitionImpl>();
        }
        if (!this.outgoingTransitions.contains(transition)) {
            this.outgoingTransitions.add(transition);
        }
        this.outgoingTransitionsMap = null;
        return transition;
    }

    public boolean removeOutgoingTransition(TransitionImpl transition) {
        if (transition != null && this.outgoingTransitions != null) {
            boolean isRemoved = this.outgoingTransitions.remove(transition);
            if (isRemoved) {
                transition.setSource(null);
                if (this.outgoingTransitions.isEmpty()) {
                    this.outgoingTransitions = null;
                }
                this.outgoingTransitionsMap = null;
            }
            return isRemoved;
        }
        return false;
    }

    @Override
    public TransitionImpl getOutgoingTransition(String transitionName) {
        return this.getOutgoingTransitionsMap() != null ? this.outgoingTransitionsMap.get(transitionName) : null;
    }

    @Override
    public TransitionImpl findOutgoingTransition(String transitionName) {
        TransitionImpl transition = this.getOutgoingTransition(transitionName);
        if (transition != null) {
            return transition;
        }
        if (this.parentNode != null) {
            return this.parentNode.findOutgoingTransition(transitionName);
        }
        return null;
    }

    public TransitionImpl findDefaultTransition() {
        if (this.defaultTransition != null) {
            return this.defaultTransition;
        }
        if (this.parentNode != null) {
            return this.parentNode.findDefaultTransition();
        }
        return null;
    }

    @Override
    public List<Transition> getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    @Override
    public boolean hasOutgoingTransition(String transitionName) {
        return this.getOutgoingTransition(transitionName) != null;
    }

    @Override
    public boolean hasOutgoingTransitions() {
        return this.outgoingTransitions != null && !this.outgoingTransitions.isEmpty();
    }

    public void setOutgoingTransitions(List<TransitionImpl> outgoingTransitions) {
        if (this.outgoingTransitions != null) {
            for (TransitionImpl removedTransition : this.outgoingTransitions) {
                removedTransition.setSource(null);
            }
        }
        if (outgoingTransitions != null) {
            this.outgoingTransitions = new ArrayList<TransitionImpl>(outgoingTransitions);
            for (TransitionImpl addedTransition : outgoingTransitions) {
                addedTransition.setSource(this);
            }
        } else {
            this.outgoingTransitions = null;
        }
        this.outgoingTransitionsMap = null;
    }

    @Override
    public Map<String, Transition> getOutgoingTransitionsMap() {
        if (this.outgoingTransitionsMap == null) {
            this.outgoingTransitionsMap = NodeImpl.getTransitionsMap(this.outgoingTransitions);
        }
        return this.outgoingTransitionsMap;
    }

    public Transition addIncomingTransition(TransitionImpl transition) {
        transition.setDestination(this);
        if (this.incomingTransitions == null) {
            this.incomingTransitions = new ArrayList<TransitionImpl>();
        }
        this.incomingTransitions.add(transition);
        return transition;
    }

    public boolean removeIncomingTransition(TransitionImpl transition) {
        if (transition != null && this.incomingTransitions != null && this.incomingTransitions.remove(transition)) {
            transition.setDestination(null);
            if (this.incomingTransitions.isEmpty()) {
                this.incomingTransitions = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<Transition> getIncomingTransitions() {
        return this.incomingTransitions;
    }

    @Override
    public boolean hasIncomingTransitions() {
        return this.incomingTransitions != null && !this.incomingTransitions.isEmpty();
    }

    public void setIncomingTransitions(List<TransitionImpl> incomingTransitions) {
        if (this.incomingTransitions != null) {
            for (TransitionImpl removedTransition : this.incomingTransitions) {
                removedTransition.setDestination(null);
            }
        }
        if (incomingTransitions != null) {
            this.incomingTransitions = new ArrayList<TransitionImpl>(incomingTransitions);
            for (TransitionImpl addedTransition : incomingTransitions) {
                addedTransition.setDestination(this);
            }
        } else {
            this.incomingTransitions = null;
        }
    }

    public void setBehaviour(Activity activity) {
        this.behaviourReference = new ObjectReference<Activity>(activity);
    }

    public void setBehaviour(Descriptor descriptor) {
        this.behaviourReference = new ObjectReference(descriptor);
    }

    public void setBehaviour(String expression) {
        this.behaviourReference = new ObjectReference(expression);
    }

    public ObjectReference<Activity> getBehaviourReference() {
        return this.behaviourReference;
    }

    public void setBehaviourReference(ObjectReference<Activity> behaviourReference) {
        this.behaviourReference = behaviourReference;
    }

    public Activity getBehaviour() {
        Activity behaviour;
        Activity activity = behaviour = this.behaviourReference != null ? this.behaviourReference.get() : null;
        if (behaviour == null) {
            throw new PvmException("no behaviour on " + this);
        }
        return behaviour;
    }

    private static Map<String, TransitionImpl> getTransitionsMap(List<TransitionImpl> transitions) {
        HashMap<String, TransitionImpl> map = null;
        if (transitions != null) {
            map = new HashMap<String, TransitionImpl>();
            for (TransitionImpl transition : transitions) {
                if (map.containsKey(transition.getName())) continue;
                map.put(transition.getName(), transition);
            }
        }
        return map;
    }

    static Map<String, NodeImpl> getNodesMap(List<NodeImpl> nodes) {
        HashMap<String, NodeImpl> map = null;
        if (nodes != null) {
            map = new HashMap<String, NodeImpl>();
            for (NodeImpl node : nodes) {
                if (node.getName() == null || map.containsKey(node.getName())) continue;
                map.put(node.getName(), node);
            }
        }
        return map;
    }

    public String toString() {
        if (this.name != null) {
            return "node(" + this.name + ")";
        }
        if (this.dbid != 0L) {
            return "node(" + this.dbid + ")";
        }
        return "node(" + System.identityHashCode(this) + ")";
    }

    public List<ObservableElementImpl> getParentChain() {
        ArrayList<ObservableElementImpl> chain = new ArrayList<ObservableElementImpl>();
        for (ObservableElementImpl processElement = this; processElement != null; processElement = ((ObservableElementImpl)processElement).getParent()) {
            chain.add(processElement);
        }
        return chain;
    }

    @Override
    public ObservableElementImpl getParent() {
        return this.parentNode != null ? this.parentNode : this.processDefinition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.processDefinition == null) {
            this.name = name;
        } else {
            if (this.name != null) {
                this.processDefinition.removeNode(this);
            }
            this.name = name;
            if (name != null) {
                this.processDefinition.addNode(this);
            }
        }
    }

    @Override
    public TransitionImpl getDefaultTransition() {
        return this.defaultTransition;
    }

    public void setDefaultTransition(TransitionImpl defaultTransition) {
        this.defaultTransition = defaultTransition;
    }

    @Override
    public NodeImpl getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(NodeImpl parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public boolean isExecutionAsync() {
        return this.isExecutionAsync;
    }

    @Override
    public boolean isSignalAsync() {
        return this.isSignalAsync;
    }

    public void setSignalAsync(boolean isSignalAsync) {
        this.isSignalAsync = isSignalAsync;
    }

    public void setExecutionAsync(boolean isExecutionAsync) {
        this.isExecutionAsync = isExecutionAsync;
    }

    @Override
    public boolean isLeaveAsync() {
        return this.isLeaveAsync;
    }

    public void setLeaveAsync(boolean isLeaveAsync) {
        this.isLeaveAsync = isLeaveAsync;
    }

    @Override
    public boolean isPreviousNeeded() {
        return this.isPreviousNeeded;
    }

    public void setPreviousNeeded(boolean isPreviousNeeded) {
        this.isPreviousNeeded = isPreviousNeeded;
    }

    public boolean isLocalScope() {
        return this.isLocalScope;
    }

    public void setLocalScope(boolean isLocalScope) {
        this.isLocalScope = isLocalScope;
    }
}

