/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.pvm.Execution;
import org.jbpm.pvm.client.ClientProcessDefinition;
import org.jbpm.pvm.client.ClientProcessInstance;
import org.jbpm.pvm.internal.lob.Blob;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.internal.util.IoUtil;
import org.jbpm.pvm.model.OpenProcessDefinition;

public class ProcessDefinitionImpl
extends CompositeElementImpl
implements OpenProcessDefinition,
ClientProcessDefinition {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog(ProcessDefinitionImpl.class.getName());
    public static final int UNASSIGNED_VERSION = -1;
    protected String key;
    protected String id;
    protected int version = -1;
    protected String packageName;
    protected Date deploymentTime;
    protected NodeImpl initial;
    Map<String, Blob> attachments;

    public ProcessDefinitionImpl() {
        this.processDefinition = this;
    }

    public ClientProcessInstance createProcessInstance() {
        return this.createProcessInstance(null, null);
    }

    public ClientProcessInstance createProcessInstance(String key) {
        return this.createProcessInstance(key, null);
    }

    public ClientProcessInstance createProcessInstance(String key, Execution superProcessExecution) {
        ExecutionImpl processInstance = this.newProcessInstance();
        log.debug("creating new execution for process '" + this.name + "'");
        if (superProcessExecution != null) {
            ExecutionImpl superProcessExecutionImpl = (ExecutionImpl)superProcessExecution;
            processInstance.setSuperProcessExecution(superProcessExecutionImpl);
            superProcessExecutionImpl.setSubProcessInstance(processInstance);
        }
        processInstance.initializeProcessInstance(this, key);
        return processInstance;
    }

    public ClientProcessInstance beginProcessInstance() {
        ClientProcessInstance processInstance = this.createProcessInstance(null, null);
        processInstance.begin();
        return processInstance;
    }

    public ClientProcessInstance beginProcessInstance(String key) {
        ClientProcessInstance processInstance = this.createProcessInstance(key, null);
        processInstance.begin();
        return processInstance;
    }

    protected ExecutionImpl newProcessInstance() {
        return new ExecutionImpl();
    }

    public void addAttachment(String name, InputStream inputStream) {
        byte[] bytes = IoUtil.readBytes(inputStream);
        this.addAttachment(name, bytes);
    }

    public void addAttachment(String name, byte[] bytes) {
        Blob blob = new Blob(bytes);
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Blob>();
        }
        this.attachments.put(name, blob);
    }

    public byte[] getAttachmentBytes(String name) {
        if (this.attachments == null) {
            return null;
        }
        Blob blob = this.attachments.get(name);
        if (blob == null) {
            return null;
        }
        return blob.getBytes();
    }

    public InputStream getAttachmentInputStream(String name) {
        byte[] bytes = this.getAttachmentBytes(name);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public String toString() {
        return this.name != null ? "processDefinition(" + this.name + ")" : "processDefinition";
    }

    public NodeImpl getInitial() {
        return this.initial;
    }

    public void setInitial(NodeImpl initial) {
        this.initial = initial;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

