/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model;

import java.util.List;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.internal.model.ObservableElementImpl;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.model.Condition;
import org.jbpm.pvm.model.Transition;

public class TransitionImpl
extends ObservableElementImpl
implements Transition {
    private static final long serialVersionUID = 1L;
    protected NodeImpl source;
    protected NodeImpl destination;
    protected Descriptor conditionDescriptor;
    protected Descriptor waitConditionDescriptor;
    protected boolean isTakeAsync;

    TransitionImpl() {
    }

    public void makeDefault() {
        this.source.setDefaultTransition(this);
    }

    public String toString() {
        String destinationName = this.destination != null ? this.destination.getName() : null;
        String sourceName = this.source != null ? this.source.getName() : null;
        return (sourceName != null ? "(" + sourceName + ")--" : "--") + (this.name != null ? this.name + "-->" : ">") + (destinationName != null ? "(" + destinationName + ")" : "");
    }

    public EventImpl createEvent() {
        EventImpl event = new EventImpl();
        event.setName("transition-take");
        this.addEvent(event);
        return event;
    }

    public ObservableElementImpl getParent() {
        if (this.source == null || this.destination == null) {
            return this.processDefinition;
        }
        if (this.source.equals(this.destination)) {
            return this.source.getParent();
        }
        List<ObservableElementImpl> sourceChain = this.source.getParentChain();
        List<ObservableElementImpl> destinationChain = this.destination.getParentChain();
        for (ObservableElementImpl sourceElement : sourceChain) {
            for (ObservableElementImpl destinationElement : destinationChain) {
                if (!sourceElement.equals(destinationElement)) continue;
                return sourceElement;
            }
        }
        return null;
    }

    public void setName(String name) {
        if (this.source == null) {
            this.name = name;
        } else {
            if (this.name != null) {
                this.source.removeOutgoingTransition(this);
            }
            this.name = name;
            if (name != null) {
                this.source.addOutgoingTransition(this);
            }
        }
    }

    public Condition getCondition() {
        if (this.conditionDescriptor == null) {
            return null;
        }
        return (Condition)WireContext.create(this.conditionDescriptor);
    }

    public Condition getWaitCondition() {
        if (this.waitConditionDescriptor == null) {
            return null;
        }
        return (Condition)WireContext.create(this.waitConditionDescriptor);
    }

    public EventImpl getEvent() {
        return this.getEvent("transition-take");
    }

    public NodeImpl getSource() {
        return this.source;
    }

    public void setSource(NodeImpl source) {
        this.source = source;
    }

    public NodeImpl getDestination() {
        return this.destination;
    }

    public void setDestination(NodeImpl destination) {
        this.destination = destination;
    }

    public Descriptor getConditionDescriptor() {
        return this.conditionDescriptor;
    }

    public void setConditionDescriptor(Descriptor conditionDescriptor) {
        this.conditionDescriptor = conditionDescriptor;
    }

    public Descriptor getWaitConditionDescriptor() {
        return this.waitConditionDescriptor;
    }

    public void setWaitConditionDescriptor(Descriptor waitConditionDescriptor) {
        this.waitConditionDescriptor = waitConditionDescriptor;
    }

    public boolean isTakeAsync() {
        return this.isTakeAsync;
    }

    public void setTakeAsync(boolean isTakeAsync) {
        this.isTakeAsync = isTakeAsync;
    }
}

