/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import org.jbpm.pvm.activity.Activity;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;
import org.jbpm.pvm.internal.model.op.ExecuteNodeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteNode
implements AtomicOperation {
    private static Log log = Log.getLog(ExecuteNode.class.getName());

    @Override
    public boolean isAsync(ExecutionImpl execution) {
        return execution.getNode().isExecutionAsync();
    }

    @Override
    public void perform(ExecutionImpl execution) {
        NodeImpl node = execution.getNode();
        if (log.isTraceEnabled()) {
            if (execution.getName() != null) {
                log.trace(execution.toString() + " executes " + node);
            } else {
                log.trace("executing " + node);
            }
        }
        Activity activity = node.getBehaviour();
        try {
            execution.setPropagation(ExecutionImpl.Propagation.UNSPECIFIED);
            activity.execute(execution);
        }
        catch (Exception e) {
            execution.handleException(node, null, null, e, execution.toString() + " couldn't execute " + activity + " for node " + node);
        }
        if (execution.getPropagation() == ExecutionImpl.Propagation.UNSPECIFIED) {
            execution.proceed();
        }
    }

    public String toString() {
        return "execute(node)";
    }

    @Override
    public MessageImpl<?> createAsyncMessage(ExecutionImpl execution) {
        return new ExecuteNodeMessage(execution);
    }
}

