/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.tx.StandardResource;

public class HibernateSessionResource
implements StandardResource {
    private static final Log log = Log.getLog(HibernateSessionResource.class.getName());
    protected Session session;
    protected Transaction transaction;

    public HibernateSessionResource(Session session) {
        this.session = session;
        if (log.isTraceEnabled()) {
            log.trace("beginning transaction on hibernate session " + System.identityHashCode(session));
        }
        try {
            this.transaction = session.beginTransaction();
        }
        catch (RuntimeException e) {
            log.error("hibernate transaction begin failed.  closing hibernate session", e);
            session.close();
            throw e;
        }
        log.debug("begun hibernate transaction " + System.identityHashCode(this.transaction) + " on hibernate session " + System.identityHashCode(session));
    }

    public void prepare() {
        log.debug("flushing hibernate session " + System.identityHashCode(this.session));
        this.session.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        log.debug("committing hibernate transaction " + System.identityHashCode(this.transaction));
        try {
            this.transaction.commit();
        }
        finally {
            this.closeSession();
        }
    }

    private void closeSession() {
        log.debug("closing hibernate session " + System.identityHashCode(this.session));
        this.session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        log.debug("rolling back hibernate transaction " + System.identityHashCode(this.transaction));
        try {
            this.transaction.rollback();
        }
        finally {
            this.closeSession();
        }
    }
}

