/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.type.Type;
import org.jbpm.pvm.internal.type.TypeMapping;
import org.jbpm.pvm.internal.type.VariableTypeResolver;

public class DefaultVariableTypeResolver
implements VariableTypeResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog(DefaultVariableTypeResolver.class.getName());
    List<TypeMapping> typeMappings;

    public Type findTypeByMatch(String key, Object value) {
        if (this.typeMappings != null) {
            for (TypeMapping typeMapping : this.typeMappings) {
                if (!typeMapping.matches(key, value)) continue;
                return typeMapping.getType();
            }
        }
        return null;
    }

    public Type findTypeByName(String typeName) {
        if (this.typeMappings != null && typeName != null) {
            for (TypeMapping typeMapping : this.typeMappings) {
                Type type = typeMapping.getType();
                if (!typeName.equals(type.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public void addTypeMapping(TypeMapping typeMapping) {
        if (this.typeMappings == null) {
            this.typeMappings = new ArrayList<TypeMapping>();
        }
        this.typeMappings.add(typeMapping);
    }
}

