/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Binding;
import org.w3c.dom.Element;

public abstract class TagBinding
implements Binding {
    protected String category;
    protected String tagName;
    protected String namespaceUri;

    public TagBinding(String tagName, String namespaceUri, String category) {
        if (tagName == null) {
            throw new PvmException("tagName is null");
        }
        this.tagName = tagName;
        this.namespaceUri = namespaceUri;
        this.category = category;
    }

    public boolean matches(Element element) {
        String elementNamespaceUri = element.getNamespaceURI();
        if (elementNamespaceUri != null && this.namespaceUri != null && !this.namespaceUri.equals(elementNamespaceUri)) {
            return false;
        }
        String elementTagLocalName = XmlUtil.getTagLocalName(element);
        return this.tagName.equals(elementTagLocalName);
    }

    public String getCategory() {
        return this.category;
    }

    public String toString() {
        return this.tagName;
    }
}

