/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.operation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.util.Listener;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireException;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvokerListener
implements Listener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog(MethodInvokerListener.class.getName());
    String methodName;
    List<ArgDescriptor> argDescriptors = null;
    WireContext wireContext;
    Object target;
    transient Method method = null;

    public MethodInvokerListener(String methodName, List<ArgDescriptor> argDescriptors, WireContext wireContext, Object target) {
        this.methodName = methodName;
        this.argDescriptors = argDescriptors;
        this.wireContext = wireContext;
        this.target = target;
    }

    @Override
    public void event(Object source, String eventName, Object info) {
        log.debug("invoking " + this.methodName + " on " + this.target + " for event " + eventName);
        try {
            Object[] args = ObjectDescriptor.getArgs(this.wireContext, this.argDescriptors);
            Class<?> clazz = this.target.getClass();
            Method method = ReflectUtil.findMethod(clazz, this.methodName, this.argDescriptors, args);
            if (method == null) {
                throw new WireException("method " + ReflectUtil.getSignature(this.methodName, this.argDescriptors, args) + " unavailable for " + this.target);
            }
            ReflectUtil.invoke(method, this.target, args);
        }
        catch (WireException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WireException("couldn't invoke listener method " + this.methodName + ": " + e.getMessage(), e);
        }
    }
}

