/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.test.base;

import java.lang.reflect.Field;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.jbpm.pvm.Execution;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.model.OpenProcessDefinition;
import org.jbpm.pvm.session.DbSession;
import org.jbpm.pvm.session.PvmDbSession;
import org.jbpm.pvm.test.base.Db;
import org.jbpm.pvm.test.base.EnvironmentTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentDbTestCase
extends EnvironmentTestCase {
    Transaction transaction = null;

    public EnvironmentDbTestCase() {
    }

    public EnvironmentDbTestCase(String configResource) {
        super(configResource);
    }

    @Override
    public void setUp() throws Exception {
        if (this.isEnvironmentFactoryCached()) {
            Db.clean(this.getEnvironmentFactory());
        }
        super.setUp();
        this.beginTransaction();
    }

    @Override
    public void tearDown() throws Exception {
        this.commitTransaction();
        super.tearDown();
    }

    void beginTransaction() {
        Session session = this.environment.get(Session.class);
        this.transaction = session.beginTransaction();
    }

    void commitTransaction() {
        this.transaction.commit();
        this.transaction = null;
    }

    void rollbackTransaction() {
        this.transaction.rollback();
        this.transaction = null;
    }

    public DbSession getDbSession() {
        return this.environment.get(DbSession.class);
    }

    public void rollbackAndBeginNewTransaction() {
        this.rollbackTransaction();
        this.closeEnvironment();
        this.openEnvironment();
        this.beginTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTransaction() {
        try {
            this.commitTransaction();
            this.closeEnvironment();
        }
        finally {
            this.openEnvironment();
            this.beginTransaction();
        }
    }

    public void beginCacheTest() {
        SessionFactory sessionFactory = this.environment.get(SessionFactory.class);
        if (sessionFactory != null) {
            log.debug("=================================================================");
            log.debug("Beginning of the cache test, no more sql query should be performed before the end of the test");
            log.debug("=================================================================");
            sessionFactory.getStatistics().clear();
            sessionFactory.getStatistics().setStatisticsEnabled(true);
        }
    }

    public void endCacheTest() {
        SessionFactory sessionFactory = this.environment.get(SessionFactory.class);
        if (sessionFactory != null) {
            EnvironmentDbTestCase.assertEquals((long)0L, (long)sessionFactory.getStatistics().getEntityLoadCount());
            EnvironmentDbTestCase.assertEquals((long)0L, (long)sessionFactory.getStatistics().getCollectionLoadCount());
        }
    }

    public ProcessDefinitionImpl reload(OpenProcessDefinition processDefinition) {
        this.environment.get(PvmDbSession.class).save(processDefinition);
        this.newTransaction();
        return this.environment.get(PvmDbSession.class).get(ProcessDefinitionImpl.class, processDefinition.getDbid());
    }

    public <T> T reload(T object, Class<T> persistentClass) {
        this.environment.get(DbSession.class).save(object);
        this.newTransaction();
        Long dbid = null;
        try {
            Field dbidField = ReflectUtil.getField(persistentClass, "dbid");
            dbidField.setAccessible(true);
            dbid = (Long)dbidField.get(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.environment.get(DbSession.class).get(persistentClass, dbid);
    }

    public ExecutionImpl reload(Execution execution) {
        this.environment.get(PvmDbSession.class).save(execution);
        this.newTransaction();
        return this.environment.get(PvmDbSession.class).get(ExecutionImpl.class, execution.getDbid());
    }
}

