/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.test.base;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.env.EnvironmentFactory;
import org.jbpm.pvm.env.PvmEnvironmentFactory;
import org.jbpm.pvm.internal.log.Jdk14LogFactory;
import org.jbpm.pvm.internal.log.Log;
import org.jbpm.pvm.internal.log.LogFormatter;

public abstract class JbpmTestCase
extends TestCase {
    protected static Log log;

    public void setUp() throws Exception {
        LogFormatter.resetIndentation();
        log.info("=== starting " + this.getName() + " =============================");
    }

    public void tearDown() throws Exception {
        log.info("=== ending " + this.getName() + " =============================\n");
    }

    public void assertTextPresent(String expected, String value) {
        if (value == null || value.indexOf(expected) == -1) {
            throw new AssertionFailedError("expected presence of '" + expected + "' but was '" + value + "'");
        }
    }

    public static Environment openEnvironment(String xmlString) {
        PvmEnvironmentFactory environmentFactory = PvmEnvironmentFactory.parseXmlString(xmlString);
        return ((EnvironmentFactory)environmentFactory).openEnvironment();
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (AssertionFailedError e) {
            log.error("");
            log.error("ASSERTION FAILURE: " + e.getMessage());
            log.error("");
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    static {
        Jdk14LogFactory.initializeJdk14Logging();
        log = Log.getLog(JbpmTestCase.class.getName());
    }
}

