/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.io.ContentMetadata;
import org.jclouds.location.Provider;

@Singleton
public class TransientBlobRequestSigner
implements BlobRequestSigner {
    private final BasicAuthentication basicAuth;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Supplier<URI> endpoint;

    @Inject
    public TransientBlobRequestSigner(BasicAuthentication basicAuth, BlobToHttpGetOptions blob2HttpGetOptions, @Provider Supplier<URI> endpoint) {
        this.basicAuth = (BasicAuthentication)Preconditions.checkNotNull((Object)basicAuth, (Object)"basicAuth");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.endpoint = endpoint;
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        HttpRequest request = new HttpRequest("GET", URI.create(String.format("%s/%s/%s", this.endpoint.get(), container, name)));
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint(URI.create(String.format("%s/%s/%s", this.endpoint.get(), container, blob.getMetadata().getName()))).payload(blob.getPayload()).headers(HttpUtils.getContentHeadersFromMetadata((ContentMetadata)blob.getMetadata().getContentMetadata())).build();
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signRemoveBlob(String container, String name) {
        HttpRequest request = new HttpRequest("DELETE", URI.create(String.format("%s/%s/%s", this.endpoint.get(), container, name)));
        return this.basicAuth.filter(request);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, GetOptions options) {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint(URI.create(String.format("%s/%s/%s", this.endpoint.get(), container, name))).headers(this.blob2HttpGetOptions.apply(options).buildRequestHeaders()).build();
        return this.basicAuth.filter(request);
    }
}

