/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.DelegatingArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;

class OptionalArgumentFactory
extends DelegatingArgumentFactory {
    OptionalArgumentFactory() {
        this.register(OptionalInt.class, 4, (p, i, v) -> {
            if (v.isPresent()) {
                p.setInt(i, v.getAsInt());
            } else {
                p.setNull(i, 4);
            }
        });
        this.register(OptionalLong.class, -5, (p, i, v) -> {
            if (v.isPresent()) {
                p.setLong(i, v.getAsLong());
            } else {
                p.setNull(i, -5);
            }
        });
        this.register(OptionalDouble.class, 8, (p, i, v) -> {
            if (v.isPresent()) {
                p.setDouble(i, v.getAsDouble());
            } else {
                p.setNull(i, 8);
            }
        });
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        if (value instanceof Optional) {
            Object nestedValue = ((Optional)value).orElse(null);
            Type nestedType = OptionalArgumentFactory.findOptionalType(expectedType, nestedValue);
            return config.get(Arguments.class).findFor(nestedType, nestedValue);
        }
        return super.build(expectedType, value, config);
    }

    private static Type findOptionalType(Type wrapperType, Object nestedValue) {
        Optional<Type> nestedType;
        if (GenericTypes.getErasedType(wrapperType).equals(Optional.class) && (nestedType = GenericTypes.findGenericParameter(wrapperType, Optional.class)).isPresent()) {
            return nestedType.get();
        }
        return nestedValue == null ? Object.class : nestedValue.getClass();
    }
}

