/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.array;

import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.array.SqlArrayArgument;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.array.SqlArrayTypes;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.internal.IterableLike;

public class SqlArrayArgumentFactory
implements ArgumentFactory {
    @Override
    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        return IterableLike.elementTypeOf(type).flatMap(config.get(SqlArrayTypes.class)::findFor).map(arrayType -> this.arrayArgument(value, (SqlArrayType<?>)arrayType));
    }

    private Argument arrayArgument(Object value, SqlArrayType<?> arrayType) {
        if (value == null) {
            return new NullArgument(2003);
        }
        return new SqlArrayArgument(arrayType, value);
    }
}

