/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.meta.Beta;

@Beta
public final class JdbiCaches
implements JdbiConfig<JdbiCaches> {
    private final Map<JdbiCache<?, ?>, Map<Object, Object>> caches = new ConcurrentHashMap();

    @Override
    public JdbiCaches createCopy() {
        return this;
    }

    public static <K, V> JdbiCache<K, V> declare(Function<K, V> computer) {
        return JdbiCaches.declare(Function.identity(), computer);
    }

    public static <K, V> JdbiCache<K, V> declare(final Function<K, ?> keyNormalizer, final Function<K, V> computer) {
        return new JdbiCache<K, V>(){

            @Override
            public V get(K key, ConfigRegistry config) {
                return config.get(JdbiCaches.class).caches.computeIfAbsent(this, x -> new ConcurrentHashMap()).computeIfAbsent(keyNormalizer.apply(key), x -> computer.apply(key));
            }
        };
    }
}

