/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.statement.StatementContext;

public abstract class StatementException
extends JdbiException {
    private static final long serialVersionUID = 1L;
    private final StatementContext statementContext;

    public StatementException(Throwable cause) {
        super(cause);
        this.statementContext = null;
    }

    public StatementException(String string, Throwable throwable, StatementContext ctx) {
        super(string, throwable);
        this.statementContext = ctx;
    }

    public StatementException(String string, Throwable throwable) {
        super(string, throwable);
        this.statementContext = null;
    }

    public StatementException(Throwable cause, StatementContext ctx) {
        super(cause);
        this.statementContext = ctx;
    }

    public StatementException(String message, StatementContext ctx) {
        super(message);
        this.statementContext = ctx;
    }

    public StatementException(String string) {
        super(string);
        this.statementContext = null;
    }

    public StatementContext getStatementContext() {
        return this.statementContext;
    }

    public String getShortMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String base = super.getMessage();
        StatementContext ctx = this.getStatementContext();
        if (ctx == null) {
            return base;
        }
        return String.format("%s [statement:\"%s\", rewritten:\"%s\", parsed:\"%s\", arguments:%s]", base, ctx.getRawSql(), ctx.getRenderedSql(), ctx.getParsedSql(), ctx.getBinding());
    }
}

