/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;

import static java.util.Objects.requireNonNull;

/**
 * Holder for a {@link Class} and a {@link Method} that together
 * define which extension method was invoked.
 */
public final class ExtensionMethod {
    private final Class<?> type;
    private final Method method;

    /**
     * @param type the type the method was invoked on
     * @param method the method invoked
     */
    public ExtensionMethod(Class<?> type, Method method) {
        this.type = requireNonNull(type);
        this.method = requireNonNull(method);
    }

    /**
     * @return the type the method was invoked on
     */
    public Class<?> getType() {
        return type;
    }

    /**
     * @return the method invoked
     */
    public Method getMethod() {
        return method;
    }
}
