/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

final class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    private Utils() {
    }

    static void muteLoggers() {
        Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            if (!loggerName.startsWith("org.jeasy.rules")) continue;
            Utils.muteLogger(loggerName);
        }
    }

    private static void muteLogger(String logger) {
        Handler[] handlers;
        Logger.getLogger(logger).setUseParentHandlers(false);
        for (Handler handler : handlers = Logger.getLogger(logger).getHandlers()) {
            Logger.getLogger(logger).removeHandler(handler);
        }
    }

    static List<Class<?>> getInterfaces(Object rule) {
        ArrayList interfaces = new ArrayList();
        Class<?> clazz = rule.getClass();
        while (clazz.getSuperclass() != null) {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    static <A extends Annotation> A findAnnotation(Class<A> targetAnnotation, Class<?> annotatedType) {
        A foundAnnotation = annotatedType.getAnnotation(targetAnnotation);
        if (foundAnnotation == null) {
            for (Annotation annotation : annotatedType.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!annotationType.isAnnotationPresent(targetAnnotation)) continue;
                foundAnnotation = annotationType.getAnnotation(targetAnnotation);
                break;
            }
        }
        return foundAnnotation;
    }

    static boolean isAnnotationPresent(Class<? extends Annotation> targetAnnotation, Class<?> annotatedType) {
        return Utils.findAnnotation(targetAnnotation, annotatedType) != null;
    }

    static {
        try {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                LogManager.getLogManager().readConfiguration(Utils.class.getResourceAsStream("/logging.properties"));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load logging configuration file", e);
        }
    }
}

