/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.core.RuleProxy;

public class Rules
implements Iterable<Rule> {
    private Set<Rule> rules = new TreeSet<Rule>();

    public Rules(Set<Rule> rules) {
        this.rules = new TreeSet<Rule>(rules);
    }

    public Rules(Rule ... rules) {
        Collections.addAll(this.rules, rules);
    }

    public Rules(Object ... rules) {
        for (Object rule : rules) {
            this.register(rule);
        }
    }

    public void register(Object rule) {
        Objects.requireNonNull(rule);
        this.rules.add(RuleProxy.asRule(rule));
    }

    public void unregister(Object rule) {
        Objects.requireNonNull(rule);
        this.rules.remove(RuleProxy.asRule(rule));
    }

    public void unregister(String ruleName) {
        Objects.requireNonNull(ruleName);
        Rule rule = this.findRuleByName(ruleName);
        if (rule != null) {
            this.unregister(rule);
        }
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public void clear() {
        this.rules.clear();
    }

    @Override
    public Iterator<Rule> iterator() {
        return this.rules.iterator();
    }

    private Rule findRuleByName(String ruleName) {
        return this.rules.stream().filter(rule -> rule.getName().equalsIgnoreCase(ruleName)).findFirst().orElse(null);
    }
}

