/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.mvel;

import java.io.Reader;
import java.util.List;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.mvel.MVELRule;
import org.jeasy.rules.support.AbstractRuleFactory;
import org.jeasy.rules.support.RuleDefinition;
import org.jeasy.rules.support.reader.RuleDefinitionReader;
import org.mvel2.ParserContext;

public class MVELRuleFactory
extends AbstractRuleFactory {
    private final RuleDefinitionReader reader;
    private final ParserContext parserContext;

    public MVELRuleFactory(RuleDefinitionReader reader) {
        this(reader, new ParserContext());
    }

    public MVELRuleFactory(RuleDefinitionReader reader, ParserContext parserContext) {
        this.reader = reader;
        this.parserContext = parserContext;
    }

    public Rule createRule(Reader ruleDescriptor) throws Exception {
        List ruleDefinitions = this.reader.read(ruleDescriptor);
        if (ruleDefinitions.isEmpty()) {
            throw new IllegalArgumentException("rule descriptor is empty");
        }
        return this.createRule((RuleDefinition)ruleDefinitions.get(0));
    }

    public Rules createRules(Reader rulesDescriptor) throws Exception {
        Rules rules = new Rules(new Rule[0]);
        List ruleDefinitions = this.reader.read(rulesDescriptor);
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            rules.register(new Object[]{this.createRule(ruleDefinition)});
        }
        return rules;
    }

    protected Rule createSimpleRule(RuleDefinition ruleDefinition) {
        MVELRule mvelRule = new MVELRule(this.parserContext).name(ruleDefinition.getName()).description(ruleDefinition.getDescription()).priority(ruleDefinition.getPriority()).when(ruleDefinition.getCondition());
        for (String action : ruleDefinition.getActions()) {
            mvelRule.then(action);
        }
        return mvelRule;
    }
}

