/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.io.output.NullOutputStream;

public class SignatureOutputStream
extends FilterOutputStream {
    private final Signature sig;

    public SignatureOutputStream(OutputStream out, Signature sig) {
        super(out);
        this.sig = sig;
    }

    public SignatureOutputStream(Signature sig) {
        this((OutputStream)new NullOutputStream(), sig);
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.sig.update((byte)b);
            this.out.write(b);
        }
        catch (SignatureException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.sig.update(b, off, len);
            this.out.write(b, off, len);
        }
        catch (SignatureException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }
}

