/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.ECCurves;
import io.jenkins.cli.shaded.org.apache.sshd.common.digest.Digest;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.AbstractDH;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Objects;

public class ECDH
extends AbstractDH {
    public static final String KEX_TYPE = "ECDH";
    private ECCurves curve;
    private ECParameterSpec params;
    private ECPoint f;

    public ECDH() throws Exception {
        this((ECParameterSpec)null);
    }

    public ECDH(String curveName) throws Exception {
        this(ValidateUtils.checkNotNull(ECCurves.fromCurveName(curveName), "Unknown curve name: %s", (Object)curveName));
    }

    public ECDH(ECCurves curve) throws Exception {
        this(Objects.requireNonNull(curve, "No known curve instance provided").getParameters());
        this.curve = curve;
    }

    public ECDH(ECParameterSpec paramSpec) throws Exception {
        this.myKeyAgree = SecurityUtils.getKeyAgreement(KEX_TYPE);
        this.params = paramSpec;
    }

    @Override
    protected byte[] calculateE() throws Exception {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        KeyPairGenerator myKpairGen = SecurityUtils.getKeyPairGenerator("EC");
        myKpairGen.initialize(this.params);
        KeyPair myKpair = myKpairGen.generateKeyPair();
        this.myKeyAgree.init(myKpair.getPrivate());
        ECPublicKey pubKey = (ECPublicKey)myKpair.getPublic();
        ECPoint e = pubKey.getW();
        return ECCurves.encodeECPoint(e, this.params);
    }

    @Override
    protected byte[] calculateK() throws Exception {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        Objects.requireNonNull(this.f, "Missing 'f' value");
        ECPublicKeySpec keySpec = new ECPublicKeySpec(this.f, this.params);
        KeyFactory myKeyFac = SecurityUtils.getKeyFactory("EC");
        PublicKey yourPubKey = myKeyFac.generatePublic(keySpec);
        this.myKeyAgree.doPhase(yourPubKey, true);
        return ECDH.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    public void setCurveParameters(ECParameterSpec paramSpec) {
        this.params = paramSpec;
    }

    @Override
    public void setF(byte[] f) {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        Objects.requireNonNull(f, "No 'f' value specified");
        this.f = ECCurves.octetStringToEcPoint(f);
    }

    @Override
    public Digest getHash() throws Exception {
        if (this.curve == null) {
            Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
            this.curve = Objects.requireNonNull(ECCurves.fromCurveParameters(this.params), "Unknown curve parameters");
        }
        return this.curve.getDigestForParams();
    }

    @Override
    public String toString() {
        return super.toString() + "[curve=" + this.curve + ", f=" + this.f + "]";
    }
}

