/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension;

import io.jenkins.cli.shaded.org.apache.sshd.common.AttributeRepository;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.KexExtensionHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.parser.ServerSignatureAlgorithms;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class DefaultClientKexExtensionHandler
extends AbstractLoggingBean
implements KexExtensionHandler {
    public static final DefaultClientKexExtensionHandler INSTANCE = new DefaultClientKexExtensionHandler();
    public static final AttributeRepository.AttributeKey<Set<String>> SERVER_ALGORITHMS = new AttributeRepository.AttributeKey();

    @Override
    public boolean isKexExtensionsAvailable(Session session, KexExtensionHandler.AvailabilityPhase phase) throws IOException {
        return !KexExtensionHandler.AvailabilityPhase.PREKEX.equals((Object)phase);
    }

    @Override
    public boolean handleKexExtensionRequest(Session session, int index, int count, String name, byte[] data) throws IOException {
        if ("server-sig-algs".equals(name)) {
            this.handleServerSignatureAlgorithms(session, (Collection)ServerSignatureAlgorithms.INSTANCE.parseExtension(data));
        }
        return true;
    }

    protected void handleServerSignatureAlgorithms(Session session, Collection<String> serverAlgorithms) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServerSignatureAlgorithms({}): {}", (Object)session, (Object)serverAlgorithms);
        }
        if (serverAlgorithms != null && !serverAlgorithms.isEmpty()) {
            ArrayList<NamedFactory<Signature>> clientAlgorithms = new ArrayList<NamedFactory<Signature>>(session.getSignatureFactories());
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServerSignatureAlgorithms({}): PubkeyAcceptedAlgorithms before: {}", (Object)session, (Object)clientAlgorithms);
            }
            ArrayList<NamedFactory> unknown = new ArrayList<NamedFactory>();
            TreeSet<String> known = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            known.addAll(serverAlgorithms);
            Iterator i = clientAlgorithms.iterator();
            while (i.hasNext()) {
                NamedFactory algo = (NamedFactory)i.next();
                if (known.contains(algo.getName())) continue;
                unknown.add(algo);
                i.remove();
            }
            clientAlgorithms.addAll(unknown);
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServerSignatureAlgorithms({}): PubkeyAcceptedAlgorithms after: {}", (Object)session, (Object)clientAlgorithms);
            }
            session.setAttribute(SERVER_ALGORITHMS, known);
            session.setSignatureFactories(clientAlgorithms);
        }
    }
}

