/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Messages;
import hudson.model.AperiodicWork;
import hudson.slaves.OfflineCause;
import hudson.util.VersionNumber;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.AgentProtocol;
import jenkins.model.Jenkins;
import jenkins.model.identity.InstanceIdentityProvider;
import jenkins.security.stapler.StaplerAccessibleType;
import jenkins.slaves.RemotingVersionInfo;
import jenkins.util.SystemProperties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@StaplerAccessibleType
public final class TcpSlaveAgentListener
extends Thread {
    private final ServerSocketChannel serverSocket;
    private volatile boolean shuttingDown;
    public final int configuredPort;
    private static int iotaGen = 1;
    private static final Logger LOGGER = Logger.getLogger(TcpSlaveAgentListener.class.getName());
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static String CLI_HOST_NAME = SystemProperties.getString(TcpSlaveAgentListener.class.getName() + ".hostName");
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static Integer CLI_PORT = SystemProperties.getInteger(TcpSlaveAgentListener.class.getName() + ".port");

    public TcpSlaveAgentListener(int port) throws IOException {
        super("TCP agent listener port=" + port);
        try {
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.socket().bind(new InetSocketAddress(port));
        }
        catch (BindException e2) {
            throw (BindException)new BindException("Failed to listen on port " + port + " because it's already in use.").initCause(e2);
        }
        this.configuredPort = port;
        this.setUncaughtExceptionHandler((t, e) -> {
            LOGGER.log(Level.SEVERE, "Uncaught exception in TcpSlaveAgentListener " + t + ", attempting to reschedule thread", e);
            this.shutdown();
            TcpSlaveAgentListenerRescheduler.schedule(t, e);
        });
        LOGGER.log(Level.FINE, "TCP agent listener started on port {0}", this.getPort());
        this.start();
    }

    public int getPort() {
        return this.serverSocket.socket().getLocalPort();
    }

    public int getAdvertisedPort() {
        return CLI_PORT != null ? CLI_PORT.intValue() : this.getPort();
    }

    public String getAdvertisedHost() {
        if (CLI_HOST_NAME != null) {
            return CLI_HOST_NAME;
        }
        try {
            return new URL(Jenkins.get().getRootUrl()).getHost();
        }
        catch (NullPointerException | MalformedURLException e) {
            throw new IllegalStateException("Could not get TcpSlaveAgentListener host name", e);
        }
    }

    @Nullable
    public String getIdentityPublicKey() {
        RSAPublicKey key = InstanceIdentityProvider.RSA.getPublicKey();
        return key == null ? null : Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public String getAgentProtocolNames() {
        return StringUtils.join(Jenkins.get().getAgentProtocols(), (String)", ");
    }

    public VersionNumber getRemotingMinimumVersion() {
        return RemotingVersionInfo.getMinimumSupportedVersion();
    }

    @Override
    public void run() {
        block3: {
            try {
                while (!this.shuttingDown) {
                    Socket s = this.serverSocket.accept().socket();
                    s.setKeepAlive(true);
                    s.setTcpNoDelay(true);
                    new ConnectionHandler(s, new ConnectionHandlerFailureCallback(this){

                        @Override
                        public void run(Throwable cause) {
                            LOGGER.log(Level.WARNING, "Connection handler failed, restarting listener", cause);
                            TcpSlaveAgentListener.this.shutdown();
                            TcpSlaveAgentListenerRescheduler.schedule(this.getParentThread(), cause);
                        }
                    }).start();
                }
            }
            catch (IOException e) {
                if (this.shuttingDown) break block3;
                LOGGER.log(Level.SEVERE, "Failed to accept TCP connections", e);
            }
        }
    }

    public void shutdown() {
        this.shuttingDown = true;
        try {
            SocketAddress localAddress = this.serverSocket.getLocalAddress();
            if (localAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)localAddress;
                Socket client = new Socket(address.getHostName(), address.getPort());
                client.setSoTimeout(1000);
                new PingAgentProtocol().connect(client);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to send Ping to wake acceptor loop", e);
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to close down TCP port", e);
        }
    }

    public static class ConnectionFromCurrentPeer
    extends OfflineCause {
        public String toString() {
            return "The current peer is reconnecting";
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class TcpSlaveAgentListenerRescheduler
    extends AperiodicWork {
        private Thread originThread;
        private Throwable cause;
        private long recurrencePeriod = 5000L;
        private boolean isActive;

        public TcpSlaveAgentListenerRescheduler() {
            this.isActive = false;
        }

        public TcpSlaveAgentListenerRescheduler(Thread originThread, Throwable cause) {
            this.originThread = originThread;
            this.cause = cause;
            this.isActive = false;
        }

        public void setOriginThread(Thread originThread) {
            this.originThread = originThread;
        }

        public void setCause(Throwable cause) {
            this.cause = cause;
        }

        public void setActive(boolean active) {
            this.isActive = active;
        }

        @Override
        public long getRecurrencePeriod() {
            return this.recurrencePeriod;
        }

        @Override
        public AperiodicWork getNewInstance() {
            return new TcpSlaveAgentListenerRescheduler(this.originThread, this.cause);
        }

        @Override
        protected void doAperiodicRun() {
            if (this.isActive) {
                try {
                    int port;
                    if (this.originThread.isAlive()) {
                        this.originThread.interrupt();
                    }
                    if ((port = Jenkins.get().getSlaveAgentPort()) != -1) {
                        new TcpSlaveAgentListener(port).start();
                        LOGGER.log(Level.INFO, "Restarted TcpSlaveAgentListener");
                    } else {
                        LOGGER.log(Level.SEVERE, "Uncaught exception in TcpSlaveAgentListener " + this.originThread + ". Port is disabled, not rescheduling", this.cause);
                    }
                    this.isActive = false;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Could not reschedule TcpSlaveAgentListener - trying again.", this.cause);
                }
            }
        }

        public static void schedule(Thread originThread, Throwable cause) {
            TcpSlaveAgentListenerRescheduler.schedule(originThread, cause, 5000L);
        }

        public static void schedule(Thread originThread, Throwable cause, long approxDelay) {
            TcpSlaveAgentListenerRescheduler rescheduler = AperiodicWork.all().get(TcpSlaveAgentListenerRescheduler.class);
            rescheduler.originThread = originThread;
            rescheduler.cause = cause;
            rescheduler.recurrencePeriod = approxDelay;
            rescheduler.isActive = true;
        }
    }

    @Extension
    @Symbol(value={"ping"})
    public static class PingAgentProtocol
    extends AgentProtocol {
        private final byte[] ping = "Ping\n".getBytes(StandardCharsets.UTF_8);

        @Override
        public boolean isRequired() {
            return true;
        }

        @Override
        public String getName() {
            return "Ping";
        }

        @Override
        public String getDisplayName() {
            return Messages.TcpSlaveAgentListener_PingAgentProtocol_displayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Socket socket) throws IOException, InterruptedException {
            try (OutputStream stream = socket.getOutputStream();){
                LOGGER.log(Level.FINE, "Received ping request from {0}", socket.getRemoteSocketAddress());
                stream.write(this.ping);
                stream.flush();
                LOGGER.log(Level.FINE, "Sent ping response to {0}", socket.getRemoteSocketAddress());
            }
            finally {
                socket.close();
            }
        }

        /*
         * Exception decompiling
         */
        public boolean connect(Socket socket) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static abstract class ConnectionHandlerFailureCallback {
        private Thread parentThread;

        ConnectionHandlerFailureCallback(Thread parentThread) {
            this.parentThread = parentThread;
        }

        public Thread getParentThread() {
            return this.parentThread;
        }

        public abstract void run(Throwable var1);
    }

    private final class ConnectionHandler
    extends Thread {
        private static final String DEFAULT_RESPONSE_404 = "HTTP/1.0 404 Not Found\r\nContent-Type: text/plain;charset=UTF-8\r\n\r\nNot Found\r\n";
        private final Socket s;
        private final int id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConnectionHandler(Socket s, ConnectionHandlerFailureCallback parentTerminator) {
            this.s = s;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.id = iotaGen++;
            }
            this.setName("TCP agent connection handler #" + this.id + " with " + s.getRemoteSocketAddress());
            this.setUncaughtExceptionHandler((t, e) -> {
                LOGGER.log(Level.SEVERE, "Uncaught exception in TcpSlaveAgentListener ConnectionHandler " + t, e);
                try {
                    s.close();
                    parentTerminator.run(e);
                }
                catch (IOException e1) {
                    LOGGER.log(Level.WARNING, "Could not close socket after unexpected thread death", e1);
                }
            });
        }

        @Override
        public void run() {
            try {
                LOGGER.log(Level.FINE, "Accepted connection #{0} from {1}", new Object[]{this.id, this.s.getRemoteSocketAddress()});
                DataInputStream in = new DataInputStream(this.s.getInputStream());
                byte[] head = new byte[10];
                in.readFully(head);
                String header = new String(head, StandardCharsets.US_ASCII);
                if (header.startsWith("GET ")) {
                    this.respondHello(header, this.s);
                    return;
                }
                String s = new DataInputStream(new SequenceInputStream(new ByteArrayInputStream(head), in)).readUTF();
                if (s.startsWith("Protocol:")) {
                    String protocol = s.substring(9);
                    AgentProtocol p = AgentProtocol.of(protocol);
                    if (p != null) {
                        if (Jenkins.get().getAgentProtocols().contains(protocol)) {
                            LOGGER.log(p instanceof PingAgentProtocol ? Level.FINE : Level.INFO, "Accepted {0} connection #{1} from {2}", new Object[]{protocol, this.id, this.s.getRemoteSocketAddress()});
                            p.handle(this.s);
                        } else {
                            this.error("Disabled protocol:" + s, this.s);
                        }
                    } else {
                        this.error("Unknown protocol:", this.s);
                    }
                } else {
                    this.error("Unrecognized protocol: " + s, this.s);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Connection #" + this.id + " aborted", e);
                try {
                    this.s.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    LOGGER.log(Level.INFO, "Connection #{0} failed: {1}", new Object[]{this.id, e});
                } else {
                    LOGGER.log(Level.WARNING, "Connection #" + this.id + " failed", e);
                }
                try {
                    this.s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void respondHello(String header, Socket s) throws IOException {
            try {
                DataOutputStream out = new DataOutputStream(s.getOutputStream());
                String response = header.startsWith("GET / ") ? "HTTP/1.0 200 OK\r\nContent-Type: text/plain;charset=UTF-8\r\n\r\nJenkins-Agent-Protocols: " + TcpSlaveAgentListener.this.getAgentProtocolNames() + "\r\nJenkins-Version: " + Jenkins.VERSION + "\r\nJenkins-Session: " + Jenkins.SESSION_HASH + "\r\nClient: " + s.getInetAddress().getHostAddress() + "\r\nServer: " + s.getLocalAddress().getHostAddress() + "\r\nRemoting-Minimum-Version: " + TcpSlaveAgentListener.this.getRemotingMinimumVersion() + "\r\n" : DEFAULT_RESPONSE_404;
                out.write(response.getBytes(StandardCharsets.UTF_8));
                out.flush();
                s.shutdownOutput();
                InputStream i = s.getInputStream();
                IOUtils.copy((InputStream)i, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                s.shutdownInput();
            }
            finally {
                s.close();
            }
        }

        private void error(String msg, Socket s) throws IOException {
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            String response = msg + System.lineSeparator();
            out.write(response.getBytes(StandardCharsets.UTF_8));
            out.flush();
            s.shutdownOutput();
            LOGGER.log(Level.WARNING, "Connection #{0} is aborted: {1}", new Object[]{this.id, msg});
            s.close();
        }
    }
}

