/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli.handlers;

import hudson.model.Item;
import hudson.model.Items;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.springframework.security.core.Authentication;

public abstract class GenericItemOptionHandler<T extends Item>
extends OptionHandler<T> {
    private static final Logger LOGGER = Logger.getLogger(GenericItemOptionHandler.class.getName());

    protected GenericItemOptionHandler(CmdLineParser parser, OptionDef option, Setter<T> setter) {
        super(parser, option, setter);
    }

    protected abstract Class<T> type();

    public int parseArguments(Parameters params) throws CmdLineException {
        String src;
        Jenkins j = Jenkins.get();
        T s = j.getItemByFullName(src = params.getParameter(0), this.type());
        if (s == null) {
            Authentication who = Jenkins.getAuthentication2();
            try (ACLContext acl = ACL.as2(ACL.SYSTEM2);){
                Item actual = j.getItemByFullName(src);
                if (actual == null) {
                    LOGGER.log(Level.FINE, "really no item exists named {0}", src);
                } else {
                    LOGGER.log(Level.WARNING, "running as {0} could not find {1} of {2}", new Object[]{who.getPrincipal(), actual, this.type()});
                }
            }
            T nearest = Items.findNearest(this.type(), src, j);
            if (nearest != null) {
                throw new IllegalArgumentException("No such job '" + src + "'; perhaps you meant '" + nearest.getFullName() + "'?");
            }
            throw new IllegalArgumentException("No such job '" + src + "'");
        }
        this.setter.addValue(s);
        return 1;
    }

    public String getDefaultMetaVariable() {
        return "ITEM";
    }
}

