/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.Util;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.lifecycle.SolarisSMFLifecycle;
import hudson.lifecycle.UnixLifecycle;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.apache.commons.io.FileUtils;

public abstract class Lifecycle
implements ExtensionPoint {
    private static Lifecycle INSTANCE = null;
    private static final Logger LOGGER = Logger.getLogger(Lifecycle.class.getName());

    public static synchronized Lifecycle get() {
        if (INSTANCE == null) {
            Lifecycle instance;
            String p = SystemProperties.getString("hudson.lifecycle");
            if (p != null) {
                try {
                    ClassLoader cl = Jenkins.get().getPluginManager().uberClassLoader;
                    instance = (Lifecycle)cl.loadClass(p).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    NoSuchMethodError x = new NoSuchMethodError(e.getMessage());
                    x.initCause(e);
                    throw x;
                }
                catch (InstantiationException e) {
                    InstantiationError x = new InstantiationError(e.getMessage());
                    x.initCause(e);
                    throw x;
                }
                catch (IllegalAccessException e) {
                    IllegalAccessError x = new IllegalAccessError(e.getMessage());
                    x.initCause(e);
                    throw x;
                }
                catch (ClassNotFoundException e) {
                    NoClassDefFoundError x = new NoClassDefFoundError(e.getMessage());
                    x.initCause(e);
                    throw x;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof IOException) {
                        throw new UncheckedIOException((IOException)t);
                    }
                    if (t instanceof Exception) {
                        throw new RuntimeException(t);
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new Error(e);
                }
            }
            if (Functions.isWindows()) {
                instance = new Lifecycle(){

                    @Override
                    public void verifyRestartable() throws RestartNotSupportedException {
                        throw new RestartNotSupportedException("Default Windows lifecycle does not support restart.");
                    }
                };
            } else if (System.getenv("SMF_FMRI") != null && System.getenv("SMF_RESTARTER") != null) {
                instance = new SolarisSMFLifecycle();
            } else {
                try {
                    instance = new UnixLifecycle();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to install embedded lifecycle implementation", e);
                    instance = new Lifecycle(){

                        @Override
                        public void verifyRestartable() throws RestartNotSupportedException {
                            throw new RestartNotSupportedException("Failed to install embedded lifecycle implementation, so cannot restart: " + e, e);
                        }
                    };
                }
            }
            assert (instance != null);
            INSTANCE = instance;
        }
        return INSTANCE;
    }

    public File getHudsonWar() {
        String war = SystemProperties.getString("executable-war");
        if (war != null && new File(war).exists()) {
            return new File(war);
        }
        return null;
    }

    public void rewriteHudsonWar(File by) throws IOException {
        File dest = this.getHudsonWar();
        if (dest == null) {
            throw new IOException("jenkins.war location is not known.");
        }
        File bak = new File(dest.getPath() + ".bak");
        if (!by.equals(bak)) {
            FileUtils.copyFile((File)dest, (File)bak);
        }
        FileUtils.copyFile((File)by, (File)dest);
        if (by.equals(bak) && bak.exists()) {
            bak.delete();
        }
    }

    public boolean canRewriteHudsonWar() {
        File f = this.getHudsonWar();
        if (f == null || !f.canWrite()) {
            return false;
        }
        File parent = f.getParentFile();
        return parent != null && parent.canWrite();
    }

    public void restart() throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public void verifyRestartable() throws RestartNotSupportedException {
        if (!Util.isOverridden(Lifecycle.class, this.getClass(), "restart", new Class[0])) {
            throw new RestartNotSupportedException("Restart is not supported in this running mode (" + this.getClass().getName() + ").");
        }
    }

    public boolean canRestart() {
        try {
            this.verifyRestartable();
            return true;
        }
        catch (RestartNotSupportedException e) {
            return false;
        }
    }
}

