/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Label;
import hudson.model.ParameterDefinition;
import hudson.model.Run;
import hudson.model.queue.SubTask;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerAccessibleType;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=3)
@StaplerAccessibleType
public abstract class ParameterValue
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ParameterValue.class.getName());
    protected final String name;
    private String description;

    protected ParameterValue(String name, String description) {
        this.name = name;
        this.description = description;
    }

    protected ParameterValue(String name) {
        this(name, null);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Restricted(value={DoNotUse.class})
    public String getFormattedDescription() {
        try {
            return Jenkins.get().getMarkupFormatter().translate(this.description);
        }
        catch (IOException e) {
            LOGGER.warning("failed to translate description using configured markup formatter");
            return "";
        }
    }

    @Exported
    public final String getName() {
        return this.name;
    }

    @Deprecated
    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        if (env instanceof EnvVars) {
            if (Util.isOverridden(ParameterValue.class, this.getClass(), "buildEnvironment", Run.class, EnvVars.class)) {
                this.buildEnvironment(build, (EnvVars)env);
            } else if (Util.isOverridden(ParameterValue.class, this.getClass(), "buildEnvVars", AbstractBuild.class, EnvVars.class)) {
                this.buildEnvVars(build, (EnvVars)env);
            }
        }
    }

    @Deprecated
    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        if (Util.isOverridden(ParameterValue.class, this.getClass(), "buildEnvironment", Run.class, EnvVars.class)) {
            this.buildEnvironment(build, env);
        } else {
            this.buildEnvVars(build, (Map<String, String>)env);
        }
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        if (build instanceof AbstractBuild) {
            this.buildEnvVars((AbstractBuild)build, env);
        }
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        return null;
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return VariableResolver.NONE;
    }

    @Deprecated
    public ParameterDefinition getDefinition() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterValue other = (ParameterValue)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getShortDescription() {
        return this.toString();
    }

    public boolean isSensitive() {
        return false;
    }

    @CheckForNull
    public Object getValue() {
        return null;
    }

    public Label getAssignedLabel(SubTask task) {
        return null;
    }
}

