/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.util.Locale;
import org.kohsuke.stapler.DataBoundConstructor;

public class PasswordParameterValue
extends ParameterValue {
    @NonNull
    private final Secret value;

    public PasswordParameterValue(String name, String value) {
        this(name, value, null);
    }

    @Deprecated
    public PasswordParameterValue(String name, String value, String description) {
        super(name, description);
        this.value = Secret.fromString(value);
    }

    @DataBoundConstructor
    public PasswordParameterValue(String name, Secret value, String description) {
        super(name, description);
        this.value = value;
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        String v = Secret.toString(this.value);
        env.put(this.name, v);
        env.put(this.name.toUpperCase(Locale.ENGLISH), v);
    }

    @Override
    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            @Override
            public String resolve(String name) {
                return PasswordParameterValue.this.name.equals(name) ? Secret.toString(PasswordParameterValue.this.value) : null;
            }
        };
    }

    @Override
    public boolean isSensitive() {
        return true;
    }

    @Override
    @NonNull
    public Secret getValue() {
        return this.value;
    }

    @Override
    public String getShortDescription() {
        return this.name + "=****";
    }
}

