/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.queue.QueueTaskFuture;
import hudson.remoting.AsyncFutureImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jenkins.model.Jenkins;

public final class FutureImpl
extends AsyncFutureImpl<Queue.Executable>
implements QueueTaskFuture<Queue.Executable> {
    private final Queue.Task task;
    private final Set<Executor> executors = new HashSet<Executor>();
    final AsyncFutureImpl<Queue.Executable> start = new AsyncFutureImpl();

    public FutureImpl(Queue.Task task) {
        this.task = task;
    }

    @Override
    public Future<Queue.Executable> getStartCondition() {
        return this.start;
    }

    @Override
    public Queue.Executable waitForStart() throws InterruptedException, ExecutionException {
        return this.getStartCondition().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Queue q = Jenkins.get().getQueue();
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (!this.executors.isEmpty()) {
                if (mayInterruptIfRunning) {
                    for (Executor e : this.executors) {
                        e.interrupt();
                    }
                }
                return mayInterruptIfRunning;
            }
            return q.cancel(this.task);
        }
    }

    public synchronized void setAsCancelled() {
        super.setAsCancelled();
        if (!this.start.isDone()) {
            this.start.setAsCancelled();
        }
    }

    synchronized void addExecutor(@NonNull Executor executor) {
        this.executors.add(executor);
    }
}

