/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.MarkupText;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.EditType;
import hudson.scm.EmptyChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public abstract class ChangeLogSet<T extends Entry>
implements Iterable<T> {
    private final Run<?, ?> run;
    @Deprecated
    public final AbstractBuild<?, ?> build;
    private final RepositoryBrowser<?> browser;

    protected ChangeLogSet(Run<?, ?> run, RepositoryBrowser<?> browser) {
        this.run = run;
        this.build = run instanceof AbstractBuild ? (AbstractBuild)run : null;
        this.browser = browser;
    }

    @Deprecated
    protected ChangeLogSet(AbstractBuild<?, ?> build) {
        this(build, ChangeLogSet.browserFromBuild(build));
    }

    private static RepositoryBrowser<?> browserFromBuild(AbstractBuild<?, ?> build) {
        if (build == null) {
            return null;
        }
        return ((AbstractProject)build.getParent()).getScm().getEffectiveBrowser();
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public RepositoryBrowser<?> getBrowser() {
        return this.browser;
    }

    public abstract boolean isEmptySet();

    @Exported
    public final Object[] getItems() {
        ArrayList<Entry> r = new ArrayList<Entry>();
        for (Entry t : this) {
            r.add(t);
        }
        return r.toArray();
    }

    @Exported
    public String getKind() {
        return null;
    }

    public static ChangeLogSet<? extends Entry> createEmpty(Run build) {
        return new EmptyChangeLogSet(build);
    }

    @Deprecated
    public static ChangeLogSet<? extends Entry> createEmpty(AbstractBuild build) {
        return ChangeLogSet.createEmpty((Run)build);
    }

    public static interface AffectedFile {
        public String getPath();

        public EditType getEditType();
    }

    @ExportedBean(defaultVisibility=999)
    public static abstract class Entry {
        private ChangeLogSet parent;
        static final Logger LOGGER = Logger.getLogger(Entry.class.getName());

        public ChangeLogSet getParent() {
            return this.parent;
        }

        protected void setParent(ChangeLogSet parent) {
            this.parent = parent;
        }

        @Exported
        public String getCommitId() {
            return null;
        }

        @Exported
        public long getTimestamp() {
            return -1L;
        }

        @Exported
        public abstract String getMsg();

        @Exported
        public abstract User getAuthor();

        @Exported
        public abstract Collection<String> getAffectedPaths();

        public Collection<? extends AffectedFile> getAffectedFiles() {
            String kind;
            String scm = "this SCM";
            ChangeLogSet parent = this.getParent();
            if (null != parent && null != (kind = parent.getKind()) && kind.trim().length() > 0) {
                scm = kind;
            }
            throw new UnsupportedOperationException("getAffectedFiles() is not implemented by " + scm);
        }

        public String getMsgAnnotated() {
            MarkupText markup = new MarkupText(this.getMsg());
            for (ChangeLogAnnotator a : ChangeLogAnnotator.all()) {
                try {
                    a.annotate(this.parent.run, this, markup);
                }
                catch (Exception e) {
                    LOGGER.info("ChangeLogAnnotator " + a.toString() + " failed to annotate message '" + this.getMsg() + "'; " + e.getMessage());
                }
                catch (Error e) {
                    LOGGER.severe("ChangeLogAnnotator " + a + " failed to annotate message '" + this.getMsg() + "'; " + e.getMessage());
                }
            }
            return markup.toString(false);
        }

        public String getMsgEscaped() {
            return Util.escape(this.getMsg());
        }
    }
}

