/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.csrf;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.DefaultCrumbIssuer;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=195.0)
@Symbol(value={"crumb"})
public class GlobalCrumbIssuerConfiguration
extends GlobalConfiguration {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DISABLE_CSRF_PROTECTION = SystemProperties.getBoolean(GlobalCrumbIssuerConfiguration.class.getName() + ".DISABLE_CSRF_PROTECTION");

    @Override
    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        Jenkins j = Jenkins.get();
        if (json.has("crumbIssuer")) {
            j.setCrumbIssuer((CrumbIssuer)req.bindJSON(CrumbIssuer.class, json.getJSONObject("crumbIssuer")));
        } else {
            j.setCrumbIssuer(GlobalCrumbIssuerConfiguration.createDefaultCrumbIssuer());
        }
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public CrumbIssuer getCrumbIssuer() {
        return Jenkins.get().getCrumbIssuer();
    }

    @Restricted(value={NoExternalUse.class})
    public static CrumbIssuer createDefaultCrumbIssuer() {
        if (DISABLE_CSRF_PROTECTION) {
            return null;
        }
        return new DefaultCrumbIssuer(SystemProperties.getBoolean(Jenkins.class.getName() + ".crumbIssuerProxyCompatibility", false));
    }
}

