/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.PersistentDescriptor;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import hudson.util.LineEndingConversion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import jenkins.tasks.filters.EnvVarsFilterLocalRule;
import jenkins.tasks.filters.EnvVarsFilterLocalRuleDescriptor;
import net.sf.json.JSONObject;
import org.apache.commons.lang.SystemUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class Shell
extends CommandInterpreter {
    private Integer unstableReturn;
    private static final Logger LOGGER = Logger.getLogger(Shell.class.getName());

    @DataBoundConstructor
    public Shell(String command) {
        super(LineEndingConversion.convertEOL(command, LineEndingConversion.EOLType.Unix));
    }

    @Restricted(value={Beta.class})
    @DataBoundSetter
    public void setConfiguredLocalRules(List<EnvVarsFilterLocalRule> configuredLocalRules) {
        this.configuredLocalRules = configuredLocalRules;
    }

    private static String addLineFeedForNonASCII(String s) {
        if (!s.startsWith("#!") && s.indexOf(10) != 0) {
            return "\n" + s;
        }
        return s;
    }

    @Override
    public String[] buildCommandLine(FilePath script) {
        if (this.command.startsWith("#!")) {
            int end = this.command.indexOf(10);
            if (end < 0) {
                end = this.command.length();
            }
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(Util.tokenize(this.command.substring(0, end).trim())));
            args.add(script.getRemote());
            args.set(0, ((String)args.get(0)).substring(2));
            return args.toArray(new String[0]);
        }
        return new String[]{this.getDescriptor().getShellOrDefault(script.getChannel()), "-xe", script.getRemote()};
    }

    @Override
    protected String getContents() {
        return Shell.addLineFeedForNonASCII(LineEndingConversion.convertEOL(this.command, LineEndingConversion.EOLType.Unix));
    }

    @Override
    protected String getFileExtension() {
        return ".sh";
    }

    @CheckForNull
    public final Integer getUnstableReturn() {
        return Integer.valueOf(0).equals(this.unstableReturn) ? null : this.unstableReturn;
    }

    @DataBoundSetter
    public void setUnstableReturn(Integer unstableReturn) {
        this.unstableReturn = unstableReturn;
    }

    @Override
    protected boolean isErrorlevelForUnstableBuild(int exitCode) {
        return this.unstableReturn != null && exitCode != 0 && this.unstableReturn.equals(exitCode);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private Object readResolve() {
        Shell shell = new Shell(this.command);
        shell.setUnstableReturn(this.unstableReturn);
        shell.setConfiguredLocalRules(this.configuredLocalRules == null ? new ArrayList() : this.configuredLocalRules);
        return shell;
    }

    @Extension
    @Symbol(value={"shell"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder>
    implements PersistentDescriptor {
        private String shell;

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Restricted(value={NoExternalUse.class})
        public List<EnvVarsFilterLocalRuleDescriptor> getApplicableLocalRules() {
            return EnvVarsFilterLocalRuleDescriptor.allApplicableFor(Shell.class);
        }

        public String getShell() {
            return this.shell;
        }

        @Deprecated
        public String getShellOrDefault() {
            if (this.shell == null) {
                return SystemUtils.IS_OS_WINDOWS ? "sh" : "/bin/sh";
            }
            return this.shell;
        }

        public String getShellOrDefault(VirtualChannel channel) {
            if (this.shell != null) {
                return this.shell;
            }
            String interpreter = null;
            try {
                interpreter = (String)channel.call((Callable)new Shellinterpreter());
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            if (interpreter == null) {
                interpreter = this.getShellOrDefault();
            }
            return interpreter;
        }

        public void setShell(String shell) {
            this.shell = Util.fixEmptyAndTrim(shell);
            this.save();
        }

        @Override
        public String getDisplayName() {
            return Messages.Shell_DisplayName();
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckUnstableReturn(@QueryParameter String value) {
            long unstableReturn;
            if ((value = Util.fixEmptyAndTrim(value)) == null) {
                return FormValidation.ok();
            }
            try {
                unstableReturn = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error(hudson.model.Messages.Hudson_NotANumber());
            }
            if (unstableReturn == 0L) {
                return FormValidation.warning(Messages.Shell_invalid_exit_code_zero());
            }
            if (unstableReturn < 1L || unstableReturn > 255L) {
                return FormValidation.error(Messages.Shell_invalid_exit_code_range(unstableReturn));
            }
            return FormValidation.ok();
        }

        @Override
        public boolean configure(StaplerRequest req, JSONObject data) throws Descriptor.FormException {
            req.bindJSON((Object)this, data);
            return super.configure(req, data);
        }

        public FormValidation doCheckShell(@QueryParameter String value) {
            return FormValidation.validateExecutable(value);
        }

        private static final class Shellinterpreter
        extends MasterToSlaveCallable<String, IOException> {
            private static final long serialVersionUID = 1L;

            private Shellinterpreter() {
            }

            public String call() throws IOException {
                return SystemUtils.IS_OS_WINDOWS ? "sh" : "/bin/sh";
            }
        }
    }
}

