/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.ExtensionPoint;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolLocationNodeProperty;
import hudson.tools.ToolProperty;
import hudson.tools.ToolPropertyDescriptor;
import hudson.util.DescribableList;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class ToolInstallation
extends AbstractDescribableImpl<ToolInstallation>
implements Serializable,
ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(ToolInstallation.class.getName());
    private final String name;
    private String home;
    private DescribableList<ToolProperty<?>, ToolPropertyDescriptor> properties = new DescribableList(Saveable.NOOP);

    @Deprecated
    public ToolInstallation(String name, String home) {
        this.name = name;
        this.home = home;
    }

    public ToolInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        this.name = name;
        this.home = home;
        if (properties != null) {
            try {
                this.properties.replaceBy(properties);
                for (ToolProperty<?> p : properties) {
                    this._setTool(p, this);
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private <T extends ToolInstallation> void _setTool(ToolProperty<T> prop, ToolInstallation t) {
        prop.setTool((ToolInstallation)prop.type().cast(t));
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getHome() {
        return this.home;
    }

    public void buildEnvVars(EnvVars env) {
    }

    public synchronized DescribableList<ToolProperty<?>, ToolPropertyDescriptor> getProperties() {
        if (this.properties == null) {
            this.properties = new DescribableList(Saveable.NOOP);
        }
        return this.properties;
    }

    public ToolInstallation translate(@NonNull Node node, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
        ToolInstallation t = this;
        if (t instanceof NodeSpecific) {
            NodeSpecific n = (NodeSpecific)((Object)t);
            t = (ToolInstallation)n.forNode(node, listener);
        }
        if (t instanceof EnvironmentSpecific) {
            EnvironmentSpecific e = (EnvironmentSpecific)((Object)t);
            t = (ToolInstallation)e.forEnvironment(envs);
        }
        return t;
    }

    public ToolInstallation translate(AbstractBuild<?, ?> buildInProgress, TaskListener listener) throws IOException, InterruptedException {
        assert (buildInProgress.isBuilding());
        return this.translate(buildInProgress.getBuiltOn(), buildInProgress.getEnvironment(listener), listener);
    }

    protected String translateFor(Node node, TaskListener log) throws IOException, InterruptedException {
        return ToolLocationNodeProperty.getToolHome(node, this, log);
    }

    protected Object readResolve() {
        if (this.properties != null) {
            for (ToolProperty p : this.properties) {
                this._setTool(p, this);
            }
        }
        return this;
    }

    protected Object writeReplace() throws Exception {
        if (Channel.current() == null) {
            return this;
        }
        LOGGER.log(Level.WARNING, "Serialization of " + this.getClass().getSimpleName() + " extends ToolInstallation over Remoting is deprecated", new Throwable());
        String xml1 = Timer.get().submit(() -> Jenkins.XSTREAM2.toXML(this)).get();
        Document dom = new SAXReader().read((Reader)new StringReader(xml1));
        Element properties = dom.getRootElement().element("properties");
        if (properties != null) {
            dom.getRootElement().remove(properties);
        }
        String xml2 = dom.asXML();
        ToolInstallation clone = (ToolInstallation)Timer.get().submit(() -> Jenkins.XSTREAM2.fromXML(xml2)).get();
        return clone;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    public static DescriptorExtensionList<ToolInstallation, ToolDescriptor<?>> all() {
        return Jenkins.get().getDescriptorList(ToolInstallation.class);
    }

    protected static abstract class ToolConverter
    extends XStream2.PassthruConverter<ToolInstallation> {
        public ToolConverter(XStream2 xstream) {
            super(xstream);
        }

        @Override
        protected void callback(ToolInstallation obj, UnmarshallingContext context) {
            String s;
            if (obj.home == null && (s = this.oldHomeField(obj)) != null) {
                obj.home = s;
                OldDataMonitor.report(context, "1.286");
            }
        }

        protected abstract String oldHomeField(ToolInstallation var1);
    }
}

