/*
 * Decompiled with CFR 0.152.
 */
package hudson.triggers;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import hudson.scheduler.RareOrImpossibleDateException;
import hudson.triggers.Messages;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TimerTrigger
extends Trigger<BuildableItem> {
    @DataBoundConstructor
    public TimerTrigger(@NonNull String spec) throws ANTLRException {
        super(spec);
    }

    @Override
    public void run() {
        if (this.job == null) {
            return;
        }
        ((BuildableItem)this.job).scheduleBuild(0, new TimerTriggerCause());
    }

    public static class TimerTriggerCause
    extends Cause {
        @Override
        public String getShortDescription() {
            return Messages.TimerTrigger_TimerTriggerCause_ShortDescription();
        }

        public boolean equals(Object o) {
            return o instanceof TimerTriggerCause;
        }

        public int hashCode() {
            return 5;
        }
    }

    @Extension
    @Symbol(value={"cron"})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        @Override
        public boolean isApplicable(Item item) {
            return item instanceof BuildableItem;
        }

        @Override
        public String getDisplayName() {
            return Messages.TimerTrigger_DisplayName();
        }

        public FormValidation doCheck(@QueryParameter String value, @AncestorInPath Item item) {
            return this.doCheckSpec(value, item);
        }

        public FormValidation doCheckSpec(@QueryParameter String value, @AncestorInPath Item item) {
            try {
                CronTabList ctl = CronTabList.create(Util.fixNull(value), item != null ? Hash.from(item.getFullName()) : null);
                ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
                this.updateValidationsForSanity(validations, ctl);
                this.updateValidationsForNextRun(validations, ctl);
                return FormValidation.aggregate(validations);
            }
            catch (ANTLRException e) {
                if (value.trim().indexOf(10) == -1 && value.contains("**")) {
                    return FormValidation.error(Messages.TimerTrigger_MissingWhitespace());
                }
                return FormValidation.error(e.getMessage());
            }
        }

        private void updateValidationsForSanity(Collection<FormValidation> validations, CronTabList ctl) {
            String msg = ctl.checkSanity();
            if (msg != null) {
                validations.add(FormValidation.warning(msg));
            }
        }

        private void updateValidationsForNextRun(Collection<FormValidation> validations, CronTabList ctl) {
            try {
                Calendar prev = ctl.previous();
                Calendar next = ctl.next();
                if (prev != null && next != null) {
                    DateFormat fmt = DateFormat.getDateTimeInstance(0, 0);
                    validations.add(FormValidation.ok(Messages.TimerTrigger_would_last_have_run_at_would_next_run_at(fmt.format(prev.getTime()), fmt.format(next.getTime()))));
                } else {
                    validations.add(FormValidation.warning(Messages.TimerTrigger_no_schedules_so_will_never_run()));
                }
            }
            catch (RareOrImpossibleDateException ex) {
                validations.add(FormValidation.warning(Messages.TimerTrigger_the_specified_cron_tab_is_rare_or_impossible()));
            }
        }
    }
}

