/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.FilePath;
import hudson.Util;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class DirScanner
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract void scan(File var1, FileVisitor var2) throws IOException;

    protected final void scanSingle(File f, String relative, FileVisitor visitor) throws IOException {
        if (visitor.understandsSymlink()) {
            String target;
            try {
                target = Util.resolveSymlink(f);
            }
            catch (IOException x) {
                target = null;
            }
            if (target != null) {
                visitor.visitSymlink(f, target, relative);
                return;
            }
        }
        visitor.visit(f, relative);
    }

    private static class DescendantFileSelector
    implements FileSelector {
        private final Set<String> alreadyDeselected;
        private final FilePath baseDirFP;
        private final int baseDirPathLength;

        private DescendantFileSelector(File basedir) {
            this.baseDirFP = new FilePath(basedir);
            this.baseDirPathLength = basedir.getPath().length();
            this.alreadyDeselected = new HashSet<String>();
        }

        public boolean isSelected(File basedir, String filename, File file) throws BuildException {
            String parentRelativeName;
            String parentName = file.getParent();
            if (parentName.length() > this.baseDirPathLength && this.alreadyDeselected.contains(parentRelativeName = parentName.substring(this.baseDirPathLength + 1))) {
                this.alreadyDeselected.add(filename);
                return false;
            }
            if (file.isDirectory()) {
                try {
                    if (this.baseDirFP.isDescendant(filename)) {
                        return true;
                    }
                    this.alreadyDeselected.add(filename);
                    return false;
                }
                catch (IOException | InterruptedException e) {
                    return true;
                }
            }
            return true;
        }
    }

    public static class Glob
    extends DirScanner {
        private final String includes;
        private final String excludes;
        private boolean useDefaultExcludes = true;
        private final boolean followSymlinks;
        private static final long serialVersionUID = 1L;

        public Glob(String includes, String excludes) {
            this(includes, excludes, true, true);
        }

        public Glob(String includes, String excludes, boolean useDefaultExcludes) {
            this(includes, excludes, useDefaultExcludes, true);
        }

        @Restricted(value={NoExternalUse.class})
        public Glob(String includes, String excludes, boolean useDefaultExcludes, boolean followSymlinks) {
            this.includes = includes;
            this.excludes = excludes;
            this.useDefaultExcludes = useDefaultExcludes;
            this.followSymlinks = followSymlinks;
        }

        @Override
        public void scan(File dir, FileVisitor visitor) throws IOException {
            if (Util.fixEmpty(this.includes) == null && this.excludes == null) {
                new Full().scan(dir, visitor);
                return;
            }
            FileSet fs = Util.createFileSet(dir, this.includes, this.excludes);
            fs.setFollowSymlinks(this.followSymlinks);
            fs.setDefaultexcludes(this.useDefaultExcludes);
            if (dir.exists()) {
                DirectoryScanner ds = fs.getDirectoryScanner(new Project());
                for (String f : ds.getIncludedFiles()) {
                    File file = new File(dir, f);
                    this.scanSingle(file, f, visitor);
                }
            }
        }
    }

    public static class Filter
    extends Full {
        private final FileFilter filter;
        private static final long serialVersionUID = 1L;

        public Filter(FileFilter filter) {
            this.filter = filter;
        }

        @Override
        public void scan(File dir, FileVisitor visitor) throws IOException {
            super.scan(dir, visitor.with(this.filter));
        }
    }

    public static class Full
    extends DirScanner {
        private static final long serialVersionUID = 1L;

        private void scan(File f, String path, FileVisitor visitor) throws IOException {
            if (f.canRead()) {
                this.scanSingle(f, path + f.getName(), visitor);
                if (f.isDirectory()) {
                    for (File child : f.listFiles()) {
                        this.scan(child, path + f.getName() + '/', visitor);
                    }
                }
            }
        }

        @Override
        public void scan(File dir, FileVisitor visitor) throws IOException {
            this.scan(dir, "", visitor);
        }
    }
}

