/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.CloseProofOutputStream;
import hudson.model.TaskListener;
import hudson.remoting.RemoteOutputStream;
import hudson.util.AbstractTaskListener;
import hudson.util.NullStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

public class StreamTaskListener
extends AbstractTaskListener
implements TaskListener,
Closeable {
    @NonNull
    private PrintStream out;
    @CheckForNull
    private Charset charset;
    private static final String KEY_AUTO_FLUSH = StreamTaskListener.class.getName() + ".AUTO_FLUSH";
    private static boolean AUTO_FLUSH;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER;

    @Deprecated
    public StreamTaskListener(@NonNull PrintStream out) {
        this(out, null);
    }

    public StreamTaskListener(@NonNull OutputStream out) {
        this(out, null);
    }

    public StreamTaskListener(@NonNull OutputStream out, @CheckForNull Charset charset) {
        try {
            this.out = charset == null ? (out instanceof PrintStream ? (PrintStream)out : new PrintStream(out, false)) : new PrintStream(out, false, charset.name());
            this.charset = charset;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public StreamTaskListener(@NonNull File out) throws IOException {
        this(out, null);
    }

    public StreamTaskListener(@NonNull File out, @CheckForNull Charset charset) throws IOException {
        this(Files.newOutputStream(StreamTaskListener.asPath(out), new OpenOption[0]), charset);
    }

    private static Path asPath(@NonNull File out) throws IOException {
        try {
            return out.toPath();
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public StreamTaskListener(@NonNull File out, boolean append, @CheckForNull Charset charset) throws IOException {
        this(Files.newOutputStream(StreamTaskListener.asPath(out), StandardOpenOption.CREATE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING), charset);
    }

    public StreamTaskListener(@NonNull Writer w) throws IOException {
        this((OutputStream)new WriterOutputStream(w));
    }

    @Deprecated
    public StreamTaskListener() throws IOException {
        this(new NullStream());
    }

    public static StreamTaskListener fromStdout() {
        return new StreamTaskListener(System.out, Charset.defaultCharset());
    }

    public static StreamTaskListener fromStderr() {
        return new StreamTaskListener(System.err, Charset.defaultCharset());
    }

    @Override
    public PrintStream getLogger() {
        return this.out;
    }

    @Override
    public Charset getCharset() {
        return this.charset != null ? this.charset : Charset.defaultCharset();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(new RemoteOutputStream((OutputStream)new CloseProofOutputStream(this.out)));
        out.writeObject(this.charset == null ? null : this.charset.name());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, null, new Throwable("serializing here with AUTO_FLUSH=" + AUTO_FLUSH));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.out = new PrintStream((OutputStream)in.readObject(), AUTO_FLUSH);
        String name = (String)in.readObject();
        Charset charset = this.charset = name == null ? null : Charset.forName(name);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, null, new Throwable("deserializing here with AUTO_FLUSH=" + AUTO_FLUSH));
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to close", e);
        }
    }

    static {
        SystemProperties.allowOnAgent(KEY_AUTO_FLUSH);
        AUTO_FLUSH = SystemProperties.getBoolean(KEY_AUTO_FLUSH);
        LOGGER = Logger.getLogger(StreamTaskListener.class.getName());
    }
}

