/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.util.io.Archiver;
import hudson.util.io.TarArchiver;
import hudson.util.io.ZipArchiver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class ArchiverFactory
implements Serializable {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="used in plugin")
    public static ArchiverFactory TAR = new TarArchiverFactory(FilePath.TarCompression.NONE);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="used in plugin")
    public static ArchiverFactory TARGZ = new TarArchiverFactory(FilePath.TarCompression.GZIP);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="used in plugin")
    public static ArchiverFactory ZIP = new ZipArchiverFactory();
    private static final long serialVersionUID = 1L;

    public abstract Archiver create(OutputStream var1) throws IOException;

    @Restricted(value={NoExternalUse.class})
    public static ArchiverFactory createZipWithoutSymlink(String prefix) {
        return new ZipWithoutSymLinksArchiverFactory(prefix);
    }

    private static final class ZipWithoutSymLinksArchiverFactory
    extends ArchiverFactory {
        private final String prefix;
        private static final long serialVersionUID = 1L;

        ZipWithoutSymLinksArchiverFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Archiver create(OutputStream out) {
            return new ZipArchiver(out, true, this.prefix);
        }
    }

    private static final class ZipArchiverFactory
    extends ArchiverFactory {
        private static final long serialVersionUID = 1L;

        private ZipArchiverFactory() {
        }

        @Override
        public Archiver create(OutputStream out) {
            return new ZipArchiver(out);
        }
    }

    private static final class TarArchiverFactory
    extends ArchiverFactory {
        private final FilePath.TarCompression method;
        private static final long serialVersionUID = 1L;

        private TarArchiverFactory(FilePath.TarCompression method) {
            this.method = method;
        }

        @Override
        public Archiver create(OutputStream out) throws IOException {
            return new TarArchiver(this.method.compress(out));
        }
    }
}

