/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.ExtensionPoint;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class TransientActionFactory<T>
implements ExtensionPoint {
    private static final LoadingCache<ExtensionList<TransientActionFactory>, LoadingCache<CacheKey, List<TransientActionFactory<?>>>> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<ExtensionList<TransientActionFactory>, LoadingCache<CacheKey, List<TransientActionFactory<?>>>>(){

        public LoadingCache<CacheKey, List<TransientActionFactory<?>>> load(final ExtensionList<TransientActionFactory> allFactories) throws Exception {
            final LoadingCache perJenkinsCache = CacheBuilder.newBuilder().build(new CacheLoader<CacheKey, List<TransientActionFactory<?>>>(){

                public List<TransientActionFactory<?>> load(CacheKey key) throws Exception {
                    ArrayList factories = new ArrayList();
                    for (TransientActionFactory taf : allFactories) {
                        Class<Action> actionType = taf.actionType();
                        if (!taf.type().isAssignableFrom(key.type) || !key.actionType.isAssignableFrom(actionType) && !actionType.isAssignableFrom(key.actionType)) continue;
                        factories.add(taf);
                    }
                    return factories;
                }
            });
            allFactories.addListener(new ExtensionListListener(){

                @Override
                public void onChange() {
                    perJenkinsCache.invalidateAll();
                }
            });
            return perJenkinsCache;
        }
    });

    public abstract Class<T> type();

    public Class<? extends Action> actionType() {
        return Action.class;
    }

    @NonNull
    public abstract Collection<? extends Action> createFor(@NonNull T var1);

    @Restricted(value={NoExternalUse.class})
    public static Iterable<? extends TransientActionFactory<?>> factoriesFor(Class<?> type, Class<? extends Action> actionType) {
        return (Iterable)((LoadingCache)cache.getUnchecked(ExtensionList.lookup(TransientActionFactory.class))).getUnchecked((Object)new CacheKey(type, actionType));
    }

    private static class CacheKey {
        private final Class<?> type;
        private final Class<? extends Action> actionType;

        CacheKey(Class<?> type, Class<? extends Action> actionType) {
            this.type = type;
            this.actionType = actionType;
        }

        public boolean equals(Object obj) {
            return obj instanceof CacheKey && this.type == ((CacheKey)obj).type && this.actionType == ((CacheKey)obj).actionType;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.actionType.hashCode();
        }
    }
}

