/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ClassicPluginStrategy;
import hudson.PluginWrapper;
import hudson.util.VersionNumber;
import io.jenkins.lib.versionnumber.JavaSpecificationVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.util.java.JavaUtils;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DetachedPluginsUtil {
    private static final Logger LOGGER;
    @VisibleForTesting
    static final List<DetachedPlugin> DETACHED_LIST;
    private static final Set<String> BREAK_CYCLES;

    private DetachedPluginsUtil() {
    }

    @NonNull
    public static List<PluginWrapper.Dependency> getImpliedDependencies(String pluginName, String jenkinsVersion) {
        ArrayList<PluginWrapper.Dependency> out = new ArrayList<PluginWrapper.Dependency>();
        for (DetachedPlugin detached : DetachedPluginsUtil.getDetachedPlugins()) {
            if (detached.shortName.equals(pluginName)) continue;
            if (BREAK_CYCLES.contains(pluginName + ' ' + detached.shortName)) {
                LOGGER.log(Level.FINE, "skipping implicit dependency {0} \u2192 {1}", new Object[]{pluginName, detached.shortName});
                continue;
            }
            if (jenkinsVersion != null && !jenkinsVersion.equals("null") && new VersionNumber(jenkinsVersion).compareTo(detached.splitWhen) > 0) continue;
            out.add(new PluginWrapper.Dependency(detached.shortName + ':' + detached.requiredVersion + ";resolution:=optional"));
            LOGGER.log(Level.FINE, "adding implicit dependency {0} \u2192 {1} because of {2}", new Object[]{pluginName, detached.shortName, jenkinsVersion});
        }
        return out;
    }

    @NonNull
    public static List<DetachedPlugin> getDetachedPlugins() {
        return DETACHED_LIST.stream().filter(plugin -> JavaUtils.getCurrentJavaRuntimeVersionNumber().isNewerThanOrEqualTo((VersionNumber)plugin.getMinimumJavaVersion())).collect(Collectors.toList());
    }

    @NonNull
    public static List<DetachedPlugin> getDetachedPlugins(@NonNull VersionNumber since) {
        return DetachedPluginsUtil.getDetachedPlugins().stream().filter(detachedPlugin -> !detachedPlugin.getSplitWhen().isOlderThan(since)).collect(Collectors.toList());
    }

    public static boolean isDetachedPlugin(@NonNull String pluginId) {
        for (DetachedPlugin detachedPlugin : DetachedPluginsUtil.getDetachedPlugins()) {
            if (!detachedPlugin.getShortName().equals(pluginId)) continue;
            return true;
        }
        return false;
    }

    private static Stream<String> configLines(InputStream is) throws IOException {
        return IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.matches("#.*|\\s*"));
    }

    static {
        Throwable throwable;
        InputStream is;
        LOGGER = Logger.getLogger(DetachedPluginsUtil.class.getName());
        try {
            is = ClassicPluginStrategy.class.getResourceAsStream("/jenkins/split-plugins.txt");
            throwable = null;
            try {
                DETACHED_LIST = Collections.unmodifiableList(DetachedPluginsUtil.configLines(is).map(line -> {
                    String[] pieces = line.split(" ");
                    return new DetachedPlugin(pieces[0], pieces[1] + ".*", pieces[2], pieces.length == 4 ? pieces[3] : "1.0");
                }).collect(Collectors.toList()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException x) {
            throw new ExceptionInInitializerError(x);
        }
        try {
            is = ClassicPluginStrategy.class.getResourceAsStream("/jenkins/split-plugin-cycles.txt");
            throwable = null;
            try {
                BREAK_CYCLES = Collections.unmodifiableSet(DetachedPluginsUtil.configLines(is).collect(Collectors.toSet()));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException x) {
            throw new ExceptionInInitializerError(x);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class DetachedPlugin {
        private final String shortName;
        private final VersionNumber splitWhen;
        private final String requiredVersion;
        private final JavaSpecificationVersion minJavaVersion;

        private DetachedPlugin(String shortName, String splitWhen, String requiredVersion, String minJavaVersion) {
            this.shortName = shortName;
            this.splitWhen = new VersionNumber(splitWhen);
            this.requiredVersion = requiredVersion;
            this.minJavaVersion = new JavaSpecificationVersion(minJavaVersion);
        }

        public String getShortName() {
            return this.shortName;
        }

        public VersionNumber getSplitWhen() {
            return this.splitWhen;
        }

        public VersionNumber getRequiredVersion() {
            return new VersionNumber(this.requiredVersion);
        }

        public String toString() {
            return this.shortName + " " + this.splitWhen.toString().replace(".*", "") + " " + this.requiredVersion;
        }

        @NonNull
        public JavaSpecificationVersion getMinimumJavaVersion() {
            return this.minJavaVersion;
        }
    }
}

